/*
 * Decompiled with CFR 0.152.
 */
package udt.packets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import udt.UDTPacket;
import udt.UDTSession;
import udt.packets.PacketUtil;

public class DataPacket
implements UDTPacket,
Comparable<UDTPacket> {
    private byte[] data;
    private long packetSequenceNumber;
    private long messageNumber;
    private long timeStamp;
    private long destinationID;
    private UDTSession session;

    public DataPacket() {
    }

    public DataPacket(byte[] encodedData) {
        this(encodedData, encodedData.length);
    }

    public DataPacket(byte[] encodedData, int length) {
        this.decode(encodedData, length);
    }

    void decode(byte[] encodedData, int length) {
        this.packetSequenceNumber = PacketUtil.decode(encodedData, 0);
        this.messageNumber = PacketUtil.decode(encodedData, 4);
        this.timeStamp = PacketUtil.decode(encodedData, 8);
        this.destinationID = PacketUtil.decode(encodedData, 12);
        this.data = new byte[length - 16];
        System.arraycopy(encodedData, 16, this.data, 0, this.data.length);
    }

    public byte[] getData() {
        return this.data;
    }

    public double getLength() {
        return this.data.length;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public long getPacketSequenceNumber() {
        return this.packetSequenceNumber;
    }

    public void setPacketSequenceNumber(long sequenceNumber) {
        this.packetSequenceNumber = sequenceNumber;
    }

    @Override
    public long getMessageNumber() {
        return this.messageNumber;
    }

    @Override
    public void setMessageNumber(long messageNumber) {
        this.messageNumber = messageNumber;
    }

    @Override
    public long getDestinationID() {
        return this.destinationID;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void setDestinationID(long destinationID) {
        this.destinationID = destinationID;
    }

    @Override
    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public byte[] getHeader() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
            bos.write(PacketUtil.encodeSetHighest(false, this.packetSequenceNumber));
            bos.write(PacketUtil.encode(this.messageNumber));
            bos.write(PacketUtil.encode(this.timeStamp));
            bos.write(PacketUtil.encode(this.destinationID));
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public byte[] getEncoded() {
        byte[] header = this.getHeader();
        byte[] result = new byte[16 + this.data.length];
        System.arraycopy(header, 0, result, 0, 16);
        System.arraycopy(this.data, 0, result, 16, this.data.length);
        return result;
    }

    @Override
    public boolean isControlPacket() {
        return false;
    }

    @Override
    public boolean forSender() {
        return false;
    }

    @Override
    public boolean isConnectionHandshake() {
        return false;
    }

    @Override
    public int getControlPacketType() {
        return -1;
    }

    @Override
    public UDTSession getSession() {
        return this.session;
    }

    public void setSession(UDTSession session) {
        this.session = session;
    }

    @Override
    public int compareTo(UDTPacket other) {
        return (int)(this.getPacketSequenceNumber() - other.getPacketSequenceNumber());
    }
}

