/*
 * Decompiled with CFR 0.152.
 */
package udt.packets;

import java.io.ByteArrayOutputStream;
import udt.packets.ControlPacket;
import udt.packets.PacketUtil;

public class MessageDropRequest
extends ControlPacket {
    private long msgFirstSeqNo;
    private long msgLastSeqNo;

    public MessageDropRequest() {
        this.controlPacketType = ControlPacket.ControlPacketType.MESSAGE_DROP_REQUEST.ordinal();
    }

    public MessageDropRequest(byte[] controlInformation) {
        this();
        this.decode(controlInformation);
    }

    void decode(byte[] data) {
        this.msgFirstSeqNo = PacketUtil.decode(data, 0);
        this.msgLastSeqNo = PacketUtil.decode(data, 4);
    }

    public long getMsgFirstSeqNo() {
        return this.msgFirstSeqNo;
    }

    public void setMsgFirstSeqNo(long msgFirstSeqNo) {
        this.msgFirstSeqNo = msgFirstSeqNo;
    }

    public long getMsgLastSeqNo() {
        return this.msgLastSeqNo;
    }

    public void setMsgLastSeqNo(long msgLastSeqNo) {
        this.msgLastSeqNo = msgLastSeqNo;
    }

    @Override
    public byte[] encodeControlInformation() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(PacketUtil.encode(this.msgFirstSeqNo));
            bos.write(PacketUtil.encode(this.msgLastSeqNo));
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageDropRequest other = (MessageDropRequest)obj;
        if (this.msgFirstSeqNo != other.msgFirstSeqNo) {
            return false;
        }
        return this.msgLastSeqNo == other.msgLastSeqNo;
    }
}

