/*
 * Decompiled with CFR 0.152.
 */
package udt.receiver;

import udt.util.CircularArray;

public class PacketHistoryWindow
extends CircularArray<Long> {
    public PacketHistoryWindow(int size) {
        super(size);
    }

    public long getPacketArrivalSpeed() {
        if (!this.haveOverflow) {
            return 0L;
        }
        int num = this.max - 1;
        double total = 0.0;
        int count = 0;
        long[] intervals = new long[num];
        int pos = this.position - 1;
        if (pos < 0) {
            pos = num;
        }
        do {
            long interval;
            long upper = (Long)this.circularArray.get(pos);
            if (--pos < 0) {
                pos = num;
            }
            long lower = (Long)this.circularArray.get(pos);
            intervals[count] = interval = upper - lower;
            total += (double)interval;
        } while (++count < num);
        double AI = total / (double)num;
        count = 0;
        total = 0.0;
        for (long l : intervals) {
            if (!((double)l > AI / 8.0) || !((double)l < AI * 8.0)) continue;
            total += (double)l;
            ++count;
        }
        double medianPacketArrivalSpeed = count > 8 ? 1000000.0 * (double)count / total : 0.0;
        return (long)Math.ceil(medianPacketArrivalSpeed);
    }
}

