/*
 * Decompiled with CFR 0.152.
 */
package udt.receiver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import udt.receiver.ReceiverLossListEntry;
import udt.util.Util;

public class ReceiverLossList {
    private final PriorityBlockingQueue<ReceiverLossListEntry> backingList = new PriorityBlockingQueue(32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ReceiverLossListEntry entry) {
        PriorityBlockingQueue<ReceiverLossListEntry> priorityBlockingQueue = this.backingList;
        synchronized (priorityBlockingQueue) {
            if (!this.backingList.contains(entry)) {
                this.backingList.add(entry);
            }
        }
    }

    public void remove(long seqNo) {
        this.backingList.remove(new ReceiverLossListEntry(seqNo));
    }

    public boolean contains(ReceiverLossListEntry obj) {
        return this.backingList.contains(obj);
    }

    public boolean isEmpty() {
        return this.backingList.isEmpty();
    }

    public ReceiverLossListEntry getFirstEntry() {
        return this.backingList.peek();
    }

    public int size() {
        return this.backingList.size();
    }

    public List<Long> getFilteredSequenceNumbers(long RTT, boolean doFeedback) {
        ArrayList<Long> result = new ArrayList<Long>();
        Object[] sorted = this.backingList.toArray(new ReceiverLossListEntry[0]);
        Arrays.sort(sorted);
        for (Object e : sorted) {
            if (Util.getCurrentTime() - ((ReceiverLossListEntry)e).getLastFeedbackTime() <= ((ReceiverLossListEntry)e).getK() * RTT) continue;
            result.add(((ReceiverLossListEntry)e).getSequenceNumber());
            if (!doFeedback) continue;
            ((ReceiverLossListEntry)e).feedback();
        }
        return result;
    }

    public String toString() {
        return this.backingList.toString();
    }
}

