/*
 * Decompiled with CFR 0.152.
 */
package udt.receiver;

import udt.util.Util;

public class ReceiverLossListEntry
implements Comparable<ReceiverLossListEntry> {
    private final long sequenceNumber;
    private long lastFeedbacktime;
    private long k = 2L;

    public ReceiverLossListEntry(long sequenceNumber) {
        if (sequenceNumber <= 0L) {
            throw new IllegalArgumentException("Got sequence number " + sequenceNumber);
        }
        this.sequenceNumber = sequenceNumber;
        this.lastFeedbacktime = Util.getCurrentTime();
    }

    public void feedback() {
        ++this.k;
        this.lastFeedbacktime = Util.getCurrentTime();
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getK() {
        return this.k;
    }

    public long getLastFeedbackTime() {
        return this.lastFeedbacktime;
    }

    @Override
    public int compareTo(ReceiverLossListEntry o) {
        return (int)(this.sequenceNumber - o.sequenceNumber);
    }

    public String toString() {
        return this.sequenceNumber + "[k=" + this.k + ",time=" + this.lastFeedbacktime + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.k ^ this.k >>> 32);
        result = 31 * result + (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReceiverLossListEntry other = (ReceiverLossListEntry)obj;
        return this.sequenceNumber == other.sequenceNumber;
    }
}

