/*
 * Decompiled with CFR 0.152.
 */
package udt.unicore;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import udt.UDTClient;
import udt.util.Util;

public class FufexReceive
implements Runnable {
    private final String serverIP;
    private final String localFile;
    private final boolean append;
    private final String commOut;
    private final String commIn;

    public FufexReceive(String serverIP, String localFile, boolean append, String commOut, String commIn) {
        this.serverIP = serverIP;
        this.localFile = localFile;
        this.append = append;
        this.commIn = commIn;
        this.commOut = commOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            UDTClient client = new UDTClient(InetAddress.getLocalHost(), 0);
            int localPort = client.getEndpoint().getLocalPort();
            this.writeToOut("OUT: " + localPort);
            String peerPortS = this.readFromIn();
            int serverPort = Integer.parseInt(peerPortS);
            client.connect(this.serverIP, serverPort);
            InputStream in = client.getInputStream();
            byte[] sizeInfo = new byte[4];
            in.read(sizeInfo);
            long size = ByteBuffer.wrap(sizeInfo).getInt();
            FileOutputStream fos = new FileOutputStream(this.localFile, this.append);
            try {
                Util.copy(in, fos, size, false);
            }
            finally {
                fos.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            FufexReceive.usage();
        }
        String serverIP = args[0];
        String localFile = args[1];
        boolean append = args[2].equals("A");
        String commIn = null;
        String commOut = null;
        if (args.length > 3) {
            commOut = args[3];
            commIn = args[4];
        }
        FufexReceive fr = new FufexReceive(serverIP, localFile, append, commOut, commIn);
        fr.run();
    }

    private static void usage() {
        System.err.println("usage: recvfile server_ip local_filename mode [comm_out comm_in]");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromIn() throws IOException, InterruptedException {
        InputStream in = System.in;
        if (this.commIn != null) {
            File file = new File(this.commIn);
            while (!file.exists()) {
                Thread.sleep(2000L);
            }
            in = new FileInputStream(file);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String string = br.readLine();
            return string;
        }
        finally {
            if (this.commIn != null) {
                in.close();
            }
        }
    }

    private void writeToOut(String line) throws IOException {
        if (this.commOut != null) {
            this.appendToFile(this.commOut, line);
        } else {
            System.out.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToFile(String name, String line) throws IOException {
        File f = new File(name);
        FileOutputStream fos = new FileOutputStream(f, true);
        try {
            fos.write(line.getBytes());
            fos.write(10);
        }
        finally {
            fos.close();
        }
    }
}

