/*
 * Decompiled with CFR 0.152.
 */
package udt.util;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Application
implements Runnable {
    protected static boolean verbose;
    protected static String localIP;
    protected static int localPort;

    public void configure() {
        if (verbose) {
            Logger.getLogger("udt").setLevel(Level.INFO);
        } else {
            Logger.getLogger("udt").setLevel(Level.OFF);
        }
    }

    protected static String[] parseOptions(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) {
                Application.parseArg(arg);
                continue;
            }
            newArgs.add(arg);
        }
        return newArgs.toArray(new String[newArgs.size()]);
    }

    protected static void parseArg(String arg) {
        if ("-v".equals(arg) || "--verbose".equals(arg)) {
            verbose = true;
            return;
        }
        if (arg.startsWith("--localIP")) {
            localIP = arg.split("=")[1];
        }
        if (arg.startsWith("--localPort")) {
            localPort = Integer.parseInt(arg.split("=")[1]);
        }
    }

    static {
        localIP = null;
        localPort = -1;
    }
}

