/*
 * Decompiled with CFR 0.152.
 */
package udt.util;

import java.text.NumberFormat;
import java.util.Locale;
import udt.util.Util;

public class MeanValue {
    private double mean = 0.0;
    private int n = 0;
    private final NumberFormat format = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private final boolean verbose;
    private final long nValue;
    private long start;
    private String msg;
    private final String name;

    public MeanValue(String name) {
        this(name, false, 64);
    }

    public MeanValue(String name, boolean verbose) {
        this(name, verbose, 64);
    }

    public MeanValue(String name, boolean verbose, int nValue) {
        this.format.setMaximumFractionDigits(2);
        this.format.setGroupingUsed(false);
        this.verbose = verbose;
        this.nValue = nValue;
        this.name = name;
    }

    public void addValue(double value) {
        this.mean = (this.mean * (double)this.n + value) / (double)(this.n + 1);
        ++this.n;
        if (this.verbose && (long)this.n % this.nValue == 0L) {
            if (this.msg != null) {
                System.out.println(this.msg + " " + this.getFormattedMean());
            } else {
                System.out.println(this.getFormattedMean());
            }
        }
    }

    public double getMean() {
        return this.mean;
    }

    public String getFormattedMean() {
        return this.format.format(this.getMean());
    }

    public void clear() {
        this.mean = 0.0;
        this.n = 0;
    }

    public void begin() {
        this.start = Util.getCurrentTime();
    }

    public void end() {
        if (this.start > 0L) {
            this.addValue(Util.getCurrentTime() - this.start);
        }
    }

    public void end(String msg) {
        this.msg = msg;
        this.addValue(Util.getCurrentTime() - this.start);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

