/*
 * Decompiled with CFR 0.152.
 */
package udt.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import udt.UDTClient;
import udt.UDTOutputStream;
import udt.UDTReceiver;
import udt.util.Application;
import udt.util.Util;

public class ReceiveFile
extends Application {
    private final int serverPort;
    private final String serverHost;
    private final String remoteFile;
    private final String localFile;
    private final NumberFormat format;

    public ReceiveFile(String serverHost, int serverPort, String remoteFile, String localFile) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.remoteFile = remoteFile;
        this.localFile = localFile;
        this.format = NumberFormat.getNumberInstance();
        this.format.setMaximumFractionDigits(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.configure();
        try {
            UDTReceiver.connectionExpiryDisabled = true;
            InetAddress myHost = localIP != null ? InetAddress.getByName(localIP) : InetAddress.getLocalHost();
            UDTClient client = localPort != -1 ? new UDTClient(myHost, localPort) : new UDTClient(myHost);
            client.connect(this.serverHost, this.serverPort);
            InputStream in = client.getInputStream();
            UDTOutputStream out = (UDTOutputStream)client.getOutputStream();
            byte[] readBuf = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(readBuf);
            System.out.println("[ReceiveFile] Requesting file " + this.remoteFile);
            byte[] fName = this.remoteFile.getBytes();
            bb.putInt(fName.length + 1);
            bb.put(fName);
            bb.put((byte)0);
            out.write(readBuf, 0, bb.position());
            out.flush();
            out.pauseOutput();
            byte[] sizeInfo = new byte[4];
            while (in.read(sizeInfo) == 0) {
            }
            long size = ByteBuffer.wrap(sizeInfo).getInt();
            File file = new File(new String(this.localFile));
            System.out.println("[ReceiveFile] Write to local file <" + file.getAbsolutePath() + ">");
            FileOutputStream fos = new FileOutputStream(file);
            try {
                System.out.println("[ReceiveFile] Reading <" + size + "> bytes.");
                long start = System.currentTimeMillis();
                Util.copy(in, fos, size, false);
                long end = System.currentTimeMillis();
                double rate = 1000.0 * (double)size / 1024.0 / 1024.0 / (double)(end - start);
                System.out.println("[ReceiveFile] Rate: " + this.format.format(rate) + " MBytes/sec. " + this.format.format(8.0 * rate) + " MBit/sec.");
                client.shutdown();
                if (verbose) {
                    System.out.println(client.getStatistics());
                }
            }
            finally {
                fos.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] fullArgs) throws Exception {
        int serverPort = 65321;
        String serverHost = "localhost";
        String remoteFile = "";
        String localFile = "";
        String[] args = ReceiveFile.parseOptions(fullArgs);
        try {
            serverHost = args[0];
            serverPort = Integer.parseInt(args[1]);
            remoteFile = args[2];
            localFile = args[3];
        }
        catch (Exception ex) {
            ReceiveFile.usage();
            System.exit(1);
        }
        ReceiveFile rf = new ReceiveFile(serverHost, serverPort, remoteFile, localFile);
        rf.run();
    }

    public static void usage() {
        System.out.println("Usage: java -cp .. udt.util.ReceiveFile <server_ip> <server_port> <remote_filename> <local_filename> [--verbose] [--localPort=<port>] [--localIP=<ip>]");
    }
}

