/*
 * Decompiled with CFR 0.152.
 */
package udt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import udt.UDTReceiver;
import udt.UDTServerSocket;
import udt.UDTSocket;
import udt.packets.PacketUtil;
import udt.util.Application;
import udt.util.Util;

public class SendFile
extends Application {
    private final int serverPort;
    private final ExecutorService threadPool = Executors.newFixedThreadPool(3);

    public SendFile(int serverPort) {
        this.serverPort = serverPort;
    }

    @Override
    public void configure() {
        super.configure();
    }

    @Override
    public void run() {
        this.configure();
        try {
            UDTReceiver.connectionExpiryDisabled = true;
            InetAddress myHost = localIP != null ? InetAddress.getByName(localIP) : InetAddress.getLocalHost();
            UDTServerSocket server = new UDTServerSocket(myHost, this.serverPort);
            while (true) {
                UDTSocket socket = server.accept();
                this.threadPool.execute(new RequestRunner(socket));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] fullArgs) throws Exception {
        String[] args = SendFile.parseOptions(fullArgs);
        int serverPort = 65321;
        try {
            serverPort = Integer.parseInt(args[0]);
        }
        catch (Exception ex) {
            SendFile.usage();
            System.exit(1);
        }
        SendFile sf = new SendFile(serverPort);
        sf.run();
    }

    public static void usage() {
        System.out.println("Usage: java -cp ... udt.util.SendFile <server_port> [--verbose] [--localPort=<port>] [--localIP=<ip>]");
    }

    private static void copyFile(File file, OutputStream os) throws Exception {
        FileChannel c = new RandomAccessFile(file, "r").getChannel();
        MappedByteBuffer b = c.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        byte[] buf = new byte[0x100000];
        int len = 0;
        do {
            len = Math.min(buf.length, b.remaining());
            b.get(buf, 0, len);
            os.write(buf, 0, len);
        } while (b.remaining() != 0);
        os.flush();
    }

    public static class RequestRunner
    implements Runnable {
        private static final Logger logger = Logger.getLogger(RequestRunner.class.getName());
        private final UDTSocket socket;
        private final NumberFormat format = NumberFormat.getNumberInstance();
        private final boolean memMapped;

        public RequestRunner(UDTSocket socket) {
            this.socket = socket;
            this.format.setMaximumFractionDigits(3);
            this.memMapped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                logger.info("Handling request from " + this.socket.getSession().getDestination());
                InputStream in = this.socket.getInputStream();
                OutputStream out = this.socket.getOutputStream();
                byte[] readBuf = new byte[32768];
                ByteBuffer bb = ByteBuffer.wrap(readBuf);
                while (in.read(readBuf) == 0) {
                    Thread.sleep(100L);
                }
                int length = bb.getInt();
                byte[] fileName = new byte[length - 1];
                bb.get(fileName);
                File file = new File(new String(fileName));
                System.out.println("[SendFile] File requested: '" + file.getPath() + "'");
                FileInputStream fis = null;
                try {
                    long size = file.length();
                    System.out.println("[SendFile] File size: " + size);
                    out.write(PacketUtil.encode(size));
                    long start = System.currentTimeMillis();
                    if (this.memMapped) {
                        SendFile.copyFile(file, out);
                    } else {
                        fis = new FileInputStream(file);
                        Util.copy(fis, out, size, false);
                    }
                    long end = System.currentTimeMillis();
                    System.out.println(this.socket.getSession().getStatistics().toString());
                    double rate = 1000.0 * (double)size / 1024.0 / 1024.0 / (double)(end - start);
                    System.out.println("[SendFile] Rate: " + this.format.format(rate) + " MBytes/sec. " + this.format.format(8.0 * rate) + " MBit/sec.");
                    if (Boolean.getBoolean("udt.sender.storeStatistics")) {
                        this.socket.getSession().getStatistics().writeParameterHistory(new File("udtstats-" + System.currentTimeMillis() + ".csv"));
                    }
                }
                finally {
                    this.socket.getSender().stop();
                    if (fis != null) {
                        fis.close();
                    }
                }
                logger.info("Finished request from " + this.socket.getSession().getDestination());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
    }
}

