/*
 * Decompiled with CFR 0.152.
 */
package udt.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import org.apache.commons.lang.StringUtils;
import org.littleshoot.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import udt.UDTClient;
import udt.UDTReceiver;
import udt.util.Application;
import udt.util.Util;

public class TestSocket
extends Application {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int serverPort;
    private final String serverHost;
    private final String remoteFile;
    private final String localFile;
    private final NumberFormat format;

    public TestSocket(String serverHost, int serverPort, String remoteFile, String localFile) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.remoteFile = remoteFile;
        this.localFile = localFile;
        this.format = NumberFormat.getNumberInstance();
        this.format.setMaximumFractionDigits(3);
    }

    @Override
    public void run() {
        this.configure();
        try {
            UDTReceiver.connectionExpiryDisabled = true;
            InetAddress myHost = localIP != null ? InetAddress.getByName(localIP) : InetAddress.getLocalHost();
            UDTClient client = localPort != -1 ? new UDTClient(myHost, localPort) : new UDTClient(myHost);
            client.connect(this.serverHost, this.serverPort);
            Socket sock = client.getSocket();
            InputStream in = sock.getInputStream();
            OutputStream out = sock.getOutputStream();
            byte[] readBuf = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(readBuf);
            System.out.println("[ReceiveFile] Requesting file " + this.remoteFile);
            byte[] fName = this.remoteFile.getBytes();
            bb.putInt(fName.length + 1);
            bb.put(fName);
            bb.put((byte)0);
            out.write(readBuf, 0, bb.position());
            byte[] sizeInfo = new byte[4];
            while (in.read(sizeInfo) == 0) {
            }
            long size = ByteBuffer.wrap(sizeInfo).getInt();
            System.out.println("FILE SIZE: " + size);
            FileOutputStream fos = new FileOutputStream(this.remoteFile + ".downloaded");
            System.out.println("[ReceiveFile] Reading <" + size + "> bytes.");
            IoUtils.copy((InputStream)in, (OutputStream)fos, (long)size);
            client.shutdown();
            if (verbose) {
                System.out.println(client.getStatistics());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void requestAndResponseOnSocket(Socket sock) throws IOException {
        InputStream is = sock.getInputStream();
        OutputStream os = sock.getOutputStream();
        os.write("HEAD /uri-res/N2R?urn:sha1:TIV6N2VEORKK4BDY663FBYS6CK7LUWOB HTTP/1.1\r\n\r\n".getBytes());
        os.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String curLine = reader.readLine();
        while (StringUtils.isNotBlank((String)curLine)) {
            this.log.info("curLine: " + curLine);
            curLine = reader.readLine();
        }
        File file = new File("visualvm.zip.downloaded");
        file.delete();
        FileOutputStream fos = new FileOutputStream(file);
        IoUtils.copy((InputStream)is, (OutputStream)fos, (long)10393398L);
        fos.close();
        is.close();
        os.close();
    }

    public void run15() {
        this.configure();
        try {
            UDTReceiver.connectionExpiryDisabled = true;
            InetAddress myHost = localIP != null ? InetAddress.getByName(localIP) : InetAddress.getLocalHost();
            UDTClient client = localPort != -1 ? new UDTClient(myHost, localPort) : new UDTClient(myHost);
            client.connect(this.serverHost, this.serverPort);
            Socket sock = client.getSocket();
            InputStream in = sock.getInputStream();
            OutputStream out = sock.getOutputStream();
            byte[] readBuf = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(readBuf);
            System.out.println("[ReceiveFile] Requesting file " + this.remoteFile);
            byte[] fName = this.remoteFile.getBytes();
            bb.putInt(fName.length + 1);
            bb.put(fName);
            bb.put((byte)0);
            out.write(readBuf, 0, bb.position());
            out.flush();
            byte[] sizeInfo = new byte[4];
            while (in.read(sizeInfo) == 0) {
            }
            long size = ByteBuffer.wrap(sizeInfo).getInt();
            System.out.println("FILE SIZE: " + size);
            FileOutputStream fos = new FileOutputStream(this.remoteFile + ".downloaded");
            System.out.println("[ReceiveFile] Reading <" + size + "> bytes.");
            IoUtils.copy((InputStream)in, (OutputStream)fos, (long)size);
            client.shutdown();
            if (verbose) {
                System.out.println(client.getStatistics());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run2() {
        this.configure();
        try {
            UDTReceiver.connectionExpiryDisabled = true;
            InetAddress myHost = localIP != null ? InetAddress.getByName(localIP) : InetAddress.getLocalHost();
            UDTClient client = localPort != -1 ? new UDTClient(myHost, localPort) : new UDTClient(myHost);
            client.connect(this.serverHost, this.serverPort);
            Socket sock = client.getSocket();
            InputStream in = sock.getInputStream();
            OutputStream out = sock.getOutputStream();
            byte[] readBuf = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(readBuf);
            System.out.println("[ReceiveFile] Requesting file " + this.remoteFile);
            byte[] fName = this.remoteFile.getBytes();
            bb.putInt(fName.length + 1);
            bb.put(fName);
            bb.put((byte)0);
            out.write(readBuf, 0, bb.position());
            out.flush();
            byte[] sizeInfo = new byte[4];
            while (in.read(sizeInfo) == 0) {
            }
            long size = ByteBuffer.wrap(sizeInfo).getInt();
            File file = new File(new String(this.localFile));
            System.out.println("[ReceiveFile] Write to local file <" + file.getAbsolutePath() + ">");
            FileOutputStream fos = new FileOutputStream(file);
            try {
                System.out.println("[ReceiveFile] Reading <" + size + "> bytes.");
                long start = System.currentTimeMillis();
                Util.copy(in, fos, size, false);
                long end = System.currentTimeMillis();
                double rate = 1000.0 * (double)size / 1024.0 / 1024.0 / (double)(end - start);
                System.out.println("[ReceiveFile] Rate: " + this.format.format(rate) + " MBytes/sec. " + this.format.format(8.0 * rate) + " MBit/sec.");
                client.shutdown();
                if (verbose) {
                    System.out.println(client.getStatistics());
                }
            }
            finally {
                fos.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] fullArgs) throws Exception {
        int serverPort = 65321;
        String serverHost = "localhost";
        String remoteFile = "";
        String localFile = "";
        String[] args = TestSocket.parseOptions(fullArgs);
        try {
            serverHost = args[0];
            serverPort = Integer.parseInt(args[1]);
            remoteFile = args[2];
            localFile = args[3];
        }
        catch (Exception ex) {
            TestSocket.usage();
            System.exit(1);
        }
        TestSocket rf = new TestSocket(serverHost, serverPort, remoteFile, localFile);
        rf.run();
    }

    public static void usage() {
        System.out.println("Usage: java -cp .. udt.util.ReceiveFile <server_ip> <server_port> <remote_filename> <local_filename> [--verbose] [--localPort=<port>] [--localIP=<ip>]");
    }
}

