/*
 * Decompiled with CFR 0.152.
 */
package udt.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import udt.util.MeanValue;
import udt.util.StatisticsHistoryEntry;

public class UDTStatistics {
    private final AtomicInteger numberOfSentDataPackets = new AtomicInteger(0);
    private final AtomicInteger numberOfReceivedDataPackets = new AtomicInteger(0);
    private final AtomicInteger numberOfDuplicateDataPackets = new AtomicInteger(0);
    private final AtomicInteger numberOfMissingDataEvents = new AtomicInteger(0);
    private final AtomicInteger numberOfNAKSent = new AtomicInteger(0);
    private final AtomicInteger numberOfNAKReceived = new AtomicInteger(0);
    private final AtomicInteger numberOfRetransmittedDataPackets = new AtomicInteger(0);
    private final AtomicInteger numberOfACKSent = new AtomicInteger(0);
    private final AtomicInteger numberOfACKReceived = new AtomicInteger(0);
    private final AtomicInteger numberOfCCSlowDownEvents = new AtomicInteger(0);
    private final AtomicInteger numberOfCCWindowExceededEvents = new AtomicInteger(0);
    private final String componentDescription;
    private volatile long roundTripTime;
    private volatile long roundTripTimeVariance;
    private volatile long packetArrivalRate;
    private volatile long estimatedLinkCapacity;
    private volatile double sendPeriod;
    private volatile long congestionWindowSize;
    private final List<MeanValue> metrics = new ArrayList<MeanValue>();
    private final List<StatisticsHistoryEntry> statsHistory = new ArrayList<StatisticsHistoryEntry>();
    boolean first = true;
    private long initialTime;

    public UDTStatistics(String componentDescription) {
        this.componentDescription = componentDescription;
    }

    public int getNumberOfSentDataPackets() {
        return this.numberOfSentDataPackets.get();
    }

    public int getNumberOfReceivedDataPackets() {
        return this.numberOfReceivedDataPackets.get();
    }

    public int getNumberOfDuplicateDataPackets() {
        return this.numberOfDuplicateDataPackets.get();
    }

    public int getNumberOfNAKSent() {
        return this.numberOfNAKSent.get();
    }

    public int getNumberOfNAKReceived() {
        return this.numberOfNAKReceived.get();
    }

    public int getNumberOfRetransmittedDataPackets() {
        return this.numberOfRetransmittedDataPackets.get();
    }

    public int getNumberOfACKSent() {
        return this.numberOfACKSent.get();
    }

    public int getNumberOfACKReceived() {
        return this.numberOfACKReceived.get();
    }

    public void incNumberOfSentDataPackets() {
        this.numberOfSentDataPackets.incrementAndGet();
    }

    public void incNumberOfReceivedDataPackets() {
        this.numberOfReceivedDataPackets.incrementAndGet();
    }

    public void incNumberOfDuplicateDataPackets() {
        this.numberOfDuplicateDataPackets.incrementAndGet();
    }

    public void incNumberOfMissingDataEvents() {
        this.numberOfMissingDataEvents.incrementAndGet();
    }

    public void incNumberOfNAKSent() {
        this.numberOfNAKSent.incrementAndGet();
    }

    public void incNumberOfNAKReceived() {
        this.numberOfNAKReceived.incrementAndGet();
    }

    public void incNumberOfRetransmittedDataPackets() {
        this.numberOfRetransmittedDataPackets.incrementAndGet();
    }

    public void incNumberOfACKSent() {
        this.numberOfACKSent.incrementAndGet();
    }

    public void incNumberOfACKReceived() {
        this.numberOfACKReceived.incrementAndGet();
    }

    public void incNumberOfCCWindowExceededEvents() {
        this.numberOfCCWindowExceededEvents.incrementAndGet();
    }

    public void incNumberOfCCSlowDownEvents() {
        this.numberOfCCSlowDownEvents.incrementAndGet();
    }

    public void setRTT(long rtt, long rttVar) {
        this.roundTripTime = rtt;
        this.roundTripTimeVariance = rttVar;
    }

    public void setPacketArrivalRate(long rate, long linkCapacity) {
        this.packetArrivalRate = rate;
        this.estimatedLinkCapacity = linkCapacity;
    }

    public void setSendPeriod(double sendPeriod) {
        this.sendPeriod = sendPeriod;
    }

    public double getSendPeriod() {
        return this.sendPeriod;
    }

    public long getCongestionWindowSize() {
        return this.congestionWindowSize;
    }

    public void setCongestionWindowSize(long congestionWindowSize) {
        this.congestionWindowSize = congestionWindowSize;
    }

    public long getPacketArrivalRate() {
        return this.packetArrivalRate;
    }

    public void addMetric(MeanValue m) {
        this.metrics.add(m);
    }

    public List<MeanValue> getMetrics() {
        return Collections.unmodifiableList(this.metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Statistics for ").append(this.componentDescription).append("\n");
        sb.append("Sent data packets: ").append(this.getNumberOfSentDataPackets()).append("\n");
        sb.append("Received data packets: ").append(this.getNumberOfReceivedDataPackets()).append("\n");
        sb.append("Duplicate data packets: ").append(this.getNumberOfDuplicateDataPackets()).append("\n");
        sb.append("ACK received: ").append(this.getNumberOfACKReceived()).append("\n");
        sb.append("NAK received: ").append(this.getNumberOfNAKReceived()).append("\n");
        sb.append("Retransmitted data: ").append(this.getNumberOfNAKReceived()).append("\n");
        sb.append("NAK sent: ").append(this.getNumberOfNAKSent()).append("\n");
        sb.append("ACK sent: ").append(this.getNumberOfACKSent()).append("\n");
        if (this.roundTripTime > 0L) {
            sb.append("RTT ").append(this.roundTripTime).append(" var. ").append(this.roundTripTimeVariance).append("\n");
        }
        if (this.packetArrivalRate > 0L) {
            sb.append("Packet rate: ").append(this.packetArrivalRate).append("/sec., link capacity: ").append(this.estimatedLinkCapacity).append("/sec.\n");
        }
        if (this.numberOfMissingDataEvents.get() > 0) {
            sb.append("Sender without data events: ").append(this.numberOfMissingDataEvents.get()).append("\n");
        }
        if (this.numberOfCCSlowDownEvents.get() > 0) {
            sb.append("CC rate slowdown events: ").append(this.numberOfCCSlowDownEvents.get()).append("\n");
        }
        if (this.numberOfCCWindowExceededEvents.get() > 0) {
            sb.append("CC window slowdown events: ").append(this.numberOfCCWindowExceededEvents.get()).append("\n");
        }
        sb.append("CC parameter SND:  ").append((int)this.sendPeriod).append("\n");
        sb.append("CC parameter CWND: ").append(this.congestionWindowSize).append("\n");
        for (MeanValue v : this.metrics) {
            sb.append(v.getName()).append(": ").append(v.getFormattedMean()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeParameters() {
        List<StatisticsHistoryEntry> list = this.statsHistory;
        synchronized (list) {
            if (this.first) {
                this.first = false;
                this.statsHistory.add(new StatisticsHistoryEntry(true, 0L, this.metrics));
                this.initialTime = System.currentTimeMillis();
            }
            this.statsHistory.add(new StatisticsHistoryEntry(false, System.currentTimeMillis() - this.initialTime, this.metrics));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeParameterHistory(File toFile) throws IOException {
        FileWriter fos = new FileWriter(toFile);
        try {
            List<StatisticsHistoryEntry> list = this.statsHistory;
            synchronized (list) {
                for (StatisticsHistoryEntry s : this.statsHistory) {
                    fos.write(s.toString());
                    fos.write(10);
                }
            }
        }
        finally {
            fos.close();
        }
    }
}

