/*
 * Decompiled with CFR 0.152.
 */
package udt.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.security.MessageDigest;
import udt.UDPEndPoint;

public class Util {
    public static final long SYN = 10000L;
    public static final double SYN_D = 10000.0;

    public static long getCurrentTime() {
        return System.nanoTime() / 1000L;
    }

    public static final long getSYNTime() {
        return 10000L;
    }

    public static double getSYNTimeD() {
        return 10000.0;
    }

    public static double getSYNTimeSeconds() {
        return 0.01;
    }

    public static String readLine(InputStream input) throws IOException {
        return Util.readLine(input, '\n');
    }

    public static String readLine(InputStream input, char terminatorChar) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (true) {
            int c;
            if ((c = input.read()) < 0 && bos.size() == 0) {
                return null;
            }
            if (c < 0 || c == terminatorChar) break;
            bos.write(c);
        }
        return bos.size() > 0 ? bos.toString() : null;
    }

    public static void copy(InputStream source, OutputStream target) throws Exception {
        Util.copy(source, target, -1L, false);
    }

    public static void copy(InputStream source, OutputStream target, long size, boolean flush) throws IOException {
        int c;
        byte[] buf = new byte[524288];
        long read = 0L;
        while ((c = source.read(buf)) >= 0) {
            read += (long)c;
            target.write(buf, 0, c);
            if (flush) {
                target.flush();
            }
            if (size <= 0L || read < size) continue;
        }
        if (!flush) {
            target.flush();
        }
    }

    public static void doHolePunch(UDPEndPoint endpoint, InetAddress client, int clientPort) throws IOException {
        DatagramPacket p = new DatagramPacket(new byte[1], 1);
        p.setAddress(client);
        p.setPort(clientPort);
        endpoint.sendRaw(p);
    }

    public static String hexString(MessageDigest digest) {
        byte[] messageDigest = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < messageDigest.length; ++i) {
            String hex = Integer.toHexString(0xFF & messageDigest[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

