/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.littleshoot.util.InputRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptingInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(DecryptingInputStream.class);
    private final byte[] oneByte = new byte[1];
    private final byte[] readKey;
    private final InputStream inputStream;
    private ByteBuffer lastBuffer;
    private InputRecord currentRecord;

    public DecryptingInputStream(byte[] readKey, InputStream inputStream) {
        this.readKey = readKey;
        this.inputStream = inputStream;
        this.currentRecord = new InputRecord(readKey);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public synchronized int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        while (this.currentRecord.needsData()) {
            byte[] data = new byte[len];
            int read = this.inputStream.read(data);
            if (read == -1) {
                return read;
            }
            this.lastBuffer = ByteBuffer.wrap(data, 0, read);
            this.currentRecord.addData(this.lastBuffer);
        }
        int bytesRead = this.currentRecord.drainData(buf, off, len);
        if (!this.currentRecord.hasMoreData()) {
            LOG.info("Resetting app record");
            this.currentRecord = new InputRecord(this.readKey);
            if (this.lastBuffer != null) {
                this.currentRecord.addData(this.lastBuffer);
            } else {
                LOG.warn("No existing buffer?");
            }
        }
        return bytesRead;
    }

    @Override
    public synchronized int read() throws IOException {
        int n = this.read(this.oneByte, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.oneByte[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        LOG.info("CLOSING INPUT STREAM");
        this.inputStream.close();
    }

    public String toString() {
        return "DecryptingInputStream [inputStream=" + this.inputStream + "]";
    }
}

