/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.littleshoot.util.Pair;
import org.littleshoot.util.PairImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UriUtils.class);

    private UriUtils() {
    }

    public static String urlNonFormEncode(String s) {
        if (StringUtils.isBlank((String)s)) {
            LOG.warn("Could not encode blank string");
            throw new IllegalArgumentException("Blank string");
        }
        try {
            return URIUtil.encodeQuery((String)s, (String)"UTF-8");
        }
        catch (URIException e) {
            LOG.error("Could not encode: " + s, (Throwable)e);
            assert (false);
            return s;
        }
    }

    public static String urlFormEncode(String s) {
        if (StringUtils.isBlank((String)s)) {
            LOG.warn("Could not encode blank string");
            throw new IllegalArgumentException("Blank string");
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not encode: " + s, (Throwable)e);
            return s;
        }
    }

    public static String urlFormDecode(String s) {
        if (StringUtils.isBlank((String)s)) {
            LOG.warn("Could not encode blank string");
            throw new IllegalArgumentException("Blank string");
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not encode: " + s, (Throwable)e);
            return s;
        }
    }

    private static String getKeyValuePair(Pair<String, String> param, boolean formEncoding) {
        try {
            return UriUtils.getKeyValuePair(param.getFirst(), param.getSecond(), formEncoding);
        }
        catch (Exception e) {
            LOG.error("Could not get encoding for: {}", param, (Object)e);
            return "unknown=unknown";
        }
    }

    private static String getKeyValuePair(Map.Entry<String, String> param, boolean formEncoding) {
        try {
            return UriUtils.getKeyValuePair(param.getKey(), param.getValue(), formEncoding);
        }
        catch (Exception e) {
            LOG.error("Could not get encoding for: {}", param, (Object)e);
            return "unknown=unknown";
        }
    }

    public static String appendParam(String url, String name, String value) {
        return url + "&" + UriUtils.getKeyValuePair(name, value, true);
    }

    private static String getKeyValuePair(String key, String value, boolean formEncoding) {
        String secondEncoded;
        String firstEncoded;
        StringBuilder sb = new StringBuilder();
        if (formEncoding) {
            firstEncoded = UriUtils.urlFormEncode(key);
            secondEncoded = UriUtils.urlFormEncode(value);
        } else {
            firstEncoded = UriUtils.urlNonFormEncode(key);
            secondEncoded = UriUtils.urlNonFormEncode(value);
        }
        sb.append(firstEncoded);
        sb.append('=');
        sb.append(secondEncoded);
        return sb.toString();
    }

    private static String getUrlParameters(Collection<Pair<String, String>> parameters, boolean formEncoding) {
        StringBuilder sb = new StringBuilder();
        Iterator<Pair<String, String>> i = parameters.iterator();
        if (i.hasNext()) {
            Pair<String, String> first = i.next();
            sb.append('?');
            sb.append(UriUtils.getKeyValuePair(first, formEncoding));
            while (i.hasNext()) {
                Pair<String, String> current = i.next();
                sb.append('&');
                sb.append(UriUtils.getKeyValuePair(current, formEncoding));
            }
            return sb.toString();
        }
        return sb.toString();
    }

    private static String getUrlParameters(Map<String, String> paramMap, boolean formEncoding) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> i = paramMap.entrySet().iterator();
        if (i.hasNext()) {
            UriUtils.appendFirstValid(sb, i, formEncoding);
            while (i.hasNext()) {
                Map.Entry<String, String> current = i.next();
                if (!UriUtils.isValid(current)) continue;
                sb.append('&');
                sb.append(UriUtils.getKeyValuePair(current, formEncoding));
            }
            return sb.toString();
        }
        return sb.toString();
    }

    private static void appendFirstValid(StringBuilder sb, Iterator<Map.Entry<String, String>> i, boolean formEncoding) {
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            if (!UriUtils.isValid(entry)) continue;
            sb.append('?');
            sb.append(UriUtils.getKeyValuePair(entry, formEncoding));
            return;
        }
    }

    private static boolean isValid(Map.Entry<String, String> entry) {
        if (StringUtils.isBlank((String)entry.getKey()) || StringUtils.isBlank((String)entry.getValue())) {
            LOG.debug("Blank entry for key:" + entry.getKey() + "/value:" + entry.getValue());
            return false;
        }
        return true;
    }

    public static String newUrl(String baseUrl, Collection<Pair<String, String>> params) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl);
        sb.append(UriUtils.getUrlParameters(params, true));
        return sb.toString();
    }

    public static String newUrl(String baseUrl, Map<String, String> paramMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl);
        sb.append(UriUtils.getUrlParameters(paramMap, true));
        return sb.toString();
    }

    public static String newWwwUrlEncodedUrl(String baseUrl, Collection<Pair<String, String>> params) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl);
        sb.append(UriUtils.getUrlParameters(params, false));
        return sb.toString();
    }

    public static String newWwwUrlEncodedUrl(String baseUrl, Map<String, String> paramMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl);
        sb.append(UriUtils.getUrlParameters(paramMap, false));
        return sb.toString();
    }

    public static Pair<String, String> pair(String s1, String s2) {
        if (StringUtils.isBlank((String)s1)) {
            LOG.warn("Blank first arg");
        }
        if (StringUtils.isBlank((String)s2)) {
            LOG.warn("Blank second arg for: " + s1);
        }
        return new PairImpl<String, String>(s1, s2);
    }

    public static Pair<String, String> pair(String name, long value) {
        return UriUtils.pair(name, String.valueOf(value));
    }

    public static Pair<String, String> pair(String name, boolean value) {
        return UriUtils.pair(name, String.valueOf(value));
    }

    public static Pair<String, String> pair(String name, URI value) {
        return UriUtils.pair(name, value.toASCIIString());
    }

    public static String stripHost(String uri) {
        if (!uri.startsWith("http")) {
            return uri;
        }
        String noHttpUri = StringUtils.substringAfter((String)uri, (String)"://");
        int slashIndex = noHttpUri.indexOf("/");
        if (slashIndex == -1) {
            return "/";
        }
        String noHostUri = noHttpUri.substring(slashIndex);
        return noHostUri;
    }
}

