/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.littleshoot.util.DefaultHttpClientImpl;
import org.littleshoot.util.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XPathUtils.class);
    private final XPath m_path;
    private final Document m_doc;

    private XPathUtils(XPath path, Document doc) {
        this.m_path = path;
        this.m_doc = doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XPathUtils newXPath(URL url) {
        block10: {
            DefaultHttpClientImpl client = new DefaultHttpClientImpl();
            GetMethod method = new GetMethod(url.toExternalForm());
            try {
                int responseCode = client.executeMethod((HttpMethod)method);
                if (responseCode != 200) {
                    LOG.warn("Unexpected response code: " + responseCode);
                    break block10;
                }
                InputStream is = method.getResponseBodyAsStream();
                XPathUtils xPathUtils = XPathUtils.newXPath(is);
                return xPathUtils;
            }
            catch (HttpException e) {
                LOG.warn("Could not handle XPath", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn("Could not handle XPath", (Throwable)e);
            }
            catch (SAXException e) {
                LOG.warn("Could not handle XPath", (Throwable)e);
            }
            finally {
                method.releaseConnection();
            }
        }
        return null;
    }

    public static XPathUtils newXPath(String str) throws SAXException, IOException {
        XPathFactory xpfactory = XPathFactory.newInstance();
        XPath xPath = xpfactory.newXPath();
        Document doc = XmlUtils.toDoc(str);
        return new XPathUtils(xPath, doc);
    }

    public static XPathUtils newXPath(InputStream is) throws SAXException, IOException {
        XPathFactory xpfactory = XPathFactory.newInstance();
        XPath xPath = xpfactory.newXPath();
        Document doc = XmlUtils.toDoc(is);
        return new XPathUtils(xPath, doc);
    }

    public static XPathUtils newXPath(Document doc) {
        XPathFactory xpfactory = XPathFactory.newInstance();
        XPath xPath = xpfactory.newXPath();
        return new XPathUtils(xPath, doc);
    }

    public int getInt(String xPath) throws XPathExpressionException {
        return ((Double)this.m_path.evaluate(xPath, this.m_doc, XPathConstants.NUMBER)).intValue();
    }

    public String getString(String xPath) throws XPathExpressionException {
        return (String)this.m_path.evaluate(xPath, this.m_doc, XPathConstants.STRING);
    }

    public NodeList getNodes(String xPath) throws XPathExpressionException {
        return (NodeList)this.m_path.evaluate(xPath, this.m_doc, XPathConstants.NODESET);
    }

    public Collection<String> getStrings(String xPath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.m_path.evaluate(xPath, this.m_doc, XPathConstants.NODESET);
        int length = nodes.getLength();
        ArrayList<String> strs = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            strs.add(node.getTextContent());
        }
        return strs;
    }

    public URL getUrl(String xPath) throws MalformedURLException, XPathExpressionException {
        String url = this.getString(xPath);
        return new URL(url);
    }

    public Node getNode(String xPath) throws XPathExpressionException {
        return (Node)this.m_path.evaluate(xPath, this.m_doc, XPathConstants.NODE);
    }
}

