/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import org.littleshoot.util.LockedFileRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileLockUtils.class);

    private FileLockUtils() {
    }

    public static void callWithLock(File file, LockedFileRunner runner) {
        FileLockUtils.callWithLock(file, runner, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callWithLock(File file, LockedFileRunner runner, boolean truncate) {
        RandomAccessFile raf;
        try {
            raf = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            LOG.error("Could not find torrent data file?", (Throwable)e);
            return;
        }
        FileChannel fc = raf.getChannel();
        FileLock lock = null;
        try {
            lock = fc.lock();
            if (!lock.isValid()) {
                LOG.error("Lock not valid?");
            }
            runner.callWithLock(fc);
        }
        catch (FileNotFoundException e) {
            LOG.error("Could not find lock file?", (Throwable)e);
        }
        catch (OverlappingFileLockException e) {
            LOG.debug("Overlapping file lock", (Throwable)e);
        }
        catch (ClosedChannelException e) {
            LOG.error("Closed channel?", (Throwable)e);
        }
        catch (NonWritableChannelException e) {
            LOG.error("Closed channel?", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IO Error getting lock?", (Throwable)e);
        }
        finally {
            if (lock == null) {
                LOG.error("Lock file is null!!");
            }
            if (lock != null && truncate) {
                try {
                    LOG.debug("Truncating file");
                    fc.truncate(0L);
                    LOG.debug("Truncated file");
                    if (fc.size() != 0L) {
                        LOG.error("Truncated file to 0 but size is: " + fc.size());
                    }
                }
                catch (IOException e) {
                    LOG.warn("Could not truncate the file", (Throwable)e);
                }
            }
            try {
                raf.close();
            }
            catch (IOException e) {
                LOG.warn("Could not close RAF", (Throwable)e);
            }
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    LOG.debug("IOException releasing lock", (Throwable)e);
                }
            }
        }
    }
}

