/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);

    public static Map<String, String> toHeaderMap(byte[] httpHeaders) {
        String headers = HttpUtils.utf8(httpHeaders);
        return HttpUtils.toHeaderMap(headers);
    }

    public static Map<String, String> toHeaderMap(String headers) {
        String header;
        TreeMap<String, String> headerMap = new TreeMap<String, String>();
        if (StringUtils.isBlank((String)headers)) {
            return Collections.emptyMap();
        }
        Scanner scan = new Scanner(headers);
        scan.useDelimiter("\n");
        if (!scan.hasNext()) {
            LOG.warn("No HTTP header data??");
            return headerMap;
        }
        scan.next();
        while (scan.hasNext() && !StringUtils.isBlank((String)(header = scan.next().trim()))) {
            String headerName = StringUtils.substringBefore((String)header, (String)":").trim().toLowerCase(Locale.US);
            String headerValue = StringUtils.substringAfter((String)header, (String)":").trim().toLowerCase(Locale.US);
            headerMap.put(headerName, headerValue);
        }
        return headerMap;
    }

    private static String utf8(byte[] data) {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("No UTF-8???", (Throwable)e);
            return "";
        }
    }
}

