/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITunesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ITunesUtils.class);

    private ITunesUtils() {
    }

    public static boolean addAudioFile(File file) throws IOException {
        if (!SystemUtils.IS_OS_MAC_OSX) {
            LOG.debug("Not on OSX, not adding to iTunes");
            return false;
        }
        if (!ITunesUtils.isSupported(file)) {
            LOG.debug("iTunes does not support this file type: {}", (Object)file);
            return false;
        }
        Runtime.getRuntime().exec(ITunesUtils.createOSAScriptCommand(file));
        return true;
    }

    private static boolean isSupported(File file) {
        String extension = FilenameUtils.getExtension((String)file.getName());
        if (StringUtils.isBlank((String)extension)) {
            return false;
        }
        Object[] types = new String[]{"mp3", "aif", "aiff", "wav", "mp2", "mp4", "aac", "mid", "m4a", "m4p", "ogg"};
        return ArrayUtils.contains((Object[])types, (Object)extension.toLowerCase());
    }

    private static String[] createOSAScriptCommand(File file) {
        String path = file.getAbsolutePath();
        String playlist = "LittleShoot";
        String[] command = new String[]{"osascript", "-e", "tell application \"Finder\"", "-e", "set hfsFile to (POSIX file \"" + path + "\")", "-e", "set thePlaylist to \"LittleShoot\"", "-e", "tell application \"iTunes\"", "-e", "launch", "-e", "if not (exists playlist thePlaylist) then", "-e", "set thisPlaylist to make new playlist", "-e", "set name of thisPlaylist to thePlaylist", "-e", "end if", "-e", "add hfsFile to playlist thePlaylist", "-e", "end tell", "-e", "end tell"};
        return command;
    }

    private static final class ExecOsaScript
    implements Runnable {
        private final File m_file;

        private ExecOsaScript(File file) {
            this.m_file = file;
        }

        @Override
        public void run() {
            try {
                Runtime.getRuntime().exec(ITunesUtils.createOSAScriptCommand(this.m_file));
            }
            catch (IOException err) {
                LOG.warn("Error adding to iTunes", (Throwable)err);
            }
        }
    }
}

