/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.littleshoot.util.Base32;
import org.littleshoot.util.Sha1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Sha1Hasher {
    private static final Logger LOG = LoggerFactory.getLogger(Sha1Hasher.class);

    private Sha1Hasher() {
    }

    public static URI createSha1Urn(File file) throws IOException {
        LOG.debug("Creating SHA1 URN.");
        if (file.length() == 0L) {
            throw new IOException("Cannot publish empty files!!");
        }
        return Sha1Hasher.createSha1Urn(new FileInputStream(file));
    }

    public static URI createSha1Urn(byte[] buf) throws IOException {
        return Sha1Hasher.createSha1Urn(ByteBuffer.wrap(buf));
    }

    public static URI createSha1Urn(ByteBuffer buf) throws IOException {
        Sha1 md = new Sha1();
        md.update(buf);
        byte[] sha1 = md.digest();
        try {
            return new URI("urn:sha1:" + Base32.encode(sha1));
        }
        catch (URISyntaxException e) {
            LOG.error("Could not encode SHA-1", (Throwable)e);
            throw new IOException("bad uri: " + Base32.encode(sha1));
        }
    }

    public static URI createSha1Urn(InputStream is) throws IOException {
        return Sha1Hasher.createSha1Urn(is, new Sha1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URI createSha1Urn(InputStream is, MessageDigest md) throws IOException {
        LOG.debug("Creating SHA-1");
        byte[] buffer = new byte[65536];
        try {
            int read;
            while ((read = is.read(buffer)) != -1) {
                md.update(buffer, 0, read);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        byte[] sha1 = md.digest();
        LOG.debug("Done creating SHA-1");
        try {
            return new URI("urn:sha1:" + Base32.encode(sha1));
        }
        catch (URISyntaxException e) {
            LOG.error("Could not encode SHA-1", (Throwable)e);
            throw new IOException("bad uri: " + Base32.encode(sha1));
        }
    }

    public static String hash(String str) {
        try {
            Sha1 md = new Sha1();
            byte[] hashed = md.digest(str.getBytes("UTF-8"));
            byte[] encoded = Base64.encodeBase64((byte[])hashed);
            return new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Encoding error??", (Throwable)e);
            return "";
        }
    }
}

