/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Scanner;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.io.IOExceptionWithCause;
import org.littleshoot.util.DnsUtil;
import org.littleshoot.util.SrvUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrvUtilImpl
implements SrvUtil {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Collection<InetSocketAddress> getAddresses(String lookupName) throws IOException {
        return this.getJndiAddresses(lookupName);
    }

    private Collection<InetSocketAddress> getJndiAddresses(String lookupName) throws IOException {
        Attributes attr;
        DnsUtil util;
        try {
            util = new DnsUtil();
        }
        catch (NamingException e) {
            this.m_log.error("Could not create DNS util...", (Throwable)e);
            throw new IOExceptionWithCause("Could not create DNS util?", (Throwable)e);
        }
        try {
            attr = util.getSrvRecords(lookupName);
        }
        catch (NamingException e) {
            this.m_log.error("Invalid SRV name?", (Throwable)e);
            throw new IOExceptionWithCause("Invalid SRV name?", (Throwable)e);
        }
        Attribute srv = attr.get("SRV");
        int size = srv.size();
        LinkedList<InetSocketAddress> addresses = new LinkedList<InetSocketAddress>();
        for (int i = 0; i < size; ++i) {
            Object elem;
            try {
                elem = srv.get(i);
            }
            catch (NamingException e) {
                this.m_log.error("Invalid SRV name?", (Throwable)e);
                throw new IOExceptionWithCause("Invalid SRV name?", (Throwable)e);
            }
            String srvStr = elem.toString();
            Scanner scan = new Scanner(srvStr);
            scan.nextInt();
            scan.nextInt();
            int port = scan.nextInt();
            String fullAddress = scan.next();
            String address = fullAddress.endsWith(".") ? fullAddress.substring(0, fullAddress.length() - 1) : fullAddress;
            InetSocketAddress isa = new InetSocketAddress(address, port);
            addresses.add(isa);
        }
        Collections.shuffle(addresses);
        return new HashSet<InetSocketAddress>(addresses);
    }

    @Override
    public InetSocketAddress getAddress(String lookupName) throws IOException {
        Collection<InetSocketAddress> addresses = this.getAddresses(lookupName);
        if (addresses.isEmpty()) {
            return null;
        }
        return addresses.iterator().next();
    }
}

