/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.util.Collection;
import java.util.LinkedList;
import org.littleshoot.util.Closure;
import org.littleshoot.util.CollectionUtils;
import org.littleshoot.util.F1;
import org.littleshoot.util.F2;
import org.littleshoot.util.Predicate;

public class CollectionUtilsImpl
implements CollectionUtils {
    @Override
    public <T> void select(Collection<? extends T> collection, Predicate<T> predicate, Collection<T> result) {
        for (T current : collection) {
            if (!predicate.evaluate(current)) continue;
            result.add(current);
        }
    }

    @Override
    public <T> Collection<T> select(Collection<? extends T> collection, Predicate<T> predicate) {
        LinkedList result = new LinkedList();
        this.select(collection, predicate, result);
        return result;
    }

    @Override
    public <T> void forAllDo(Collection<? extends T> collection, Closure<T> closure) {
        for (T current : collection) {
            closure.execute(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void forAllDoSynchronized(Collection<? extends T> collection, Closure<T> closure) {
        Collection<? extends T> collection2 = collection;
        synchronized (collection2) {
            this.forAllDo(collection, closure);
        }
    }

    @Override
    public <T1, T2> Collection<T2> map(Collection<? extends T1> collection, F1<T1, T2> f) {
        LinkedList<T2> result = new LinkedList<T2>();
        for (T1 object : collection) {
            result.add(f.run(object));
        }
        return result;
    }

    @Override
    public <T1, T2> T2 foldl(F2<T2, T1, T2> f, T2 initial, Collection<? extends T1> collection) {
        T2 result = initial;
        for (T1 current : collection) {
            result = f.run(result, current);
        }
        return result;
    }

    @Override
    public long sum(Collection<Long> c) {
        F2<Long, Long, Long> f = new F2<Long, Long, Long>(){

            @Override
            public Long run(Long x, Long y) {
                return x + y;
            }
        };
        return this.foldl(f, 0L, c);
    }

    @Override
    public <T> boolean matchesAny(Collection<? extends T> collection, Predicate<T> pred) {
        for (T current : collection) {
            if (!pred.evaluate(current)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> boolean matchesAll(Collection<? extends T> collection, Predicate<T> pred) {
        for (T current : collection) {
            if (pred.evaluate(current)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean synchronizedMatchesAny(Collection<? extends T> elements, Predicate<T> pred) {
        Collection<? extends T> collection = elements;
        synchronized (collection) {
            return this.matchesAny(elements, pred);
        }
    }

    @Override
    public <T> T selectFirst(Collection<? extends T> collection, Predicate<T> pred) {
        for (T current : collection) {
            if (!pred.evaluate(current)) continue;
            return current;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T selectFirstSynchronized(Collection<? extends T> collection, Predicate<T> pred) {
        Collection<? extends T> collection2 = collection;
        synchronized (collection2) {
            return this.selectFirst(collection, pred);
        }
    }
}

