/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.IOException;
import java.io.OutputStream;
import org.littleshoot.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptingOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptingOutputStream.class);
    private final OutputStream os;
    private final byte[] key;

    public EncryptingOutputStream(byte[] key, OutputStream os) {
        this.key = key;
        this.os = os;
    }

    @Override
    public synchronized void write(byte[] data, int off, int len) throws IOException {
        byte[] encoded = CommonUtils.encode(this.key, data, off, len);
        this.os.write(encoded);
    }

    @Override
    public synchronized void write(int i) throws IOException {
        this.write(new byte[]{(byte)i}, 0, 1);
    }

    @Override
    public void close() throws IOException {
        LOG.info("CLOSING OUTPUT STREAM");
        this.os.close();
    }
}

