/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public final class FileUtils {
    private static final char[] ILLEGAL_CHARS_ANY_OS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f'};
    private static final char[] ILLEGAL_CHARS_UNIX = new char[]{'`'};
    private static final char[] ILLEGAL_CHARS_WINDOWS = new char[]{'?', '*', '\\', '<', '>', '|', '\"', ':'};

    private FileUtils() {
    }

    public static boolean hasFileExtension(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return FileUtils.hasFileExtension(file.getName());
    }

    public static boolean hasFileExtension(String name) {
        return StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)name));
    }

    public static String removeIllegalCharsFromFileName(String name) {
        block7: {
            int i;
            block6: {
                if (name.length() > 180) {
                    int extStart = name.lastIndexOf(46);
                    if (extStart == -1) {
                        name = name.substring(0, 180);
                    } else {
                        int extLength = name.length() - extStart;
                        int extEnd = extLength > 11 ? extStart + 11 : name.length();
                        name = name.substring(0, 180 - extLength) + name.substring(extStart, extEnd);
                    }
                }
                for (i = 0; i < ILLEGAL_CHARS_ANY_OS.length; ++i) {
                    name = name.replace(ILLEGAL_CHARS_ANY_OS[i], '_');
                }
                if (!SystemUtils.IS_OS_WINDOWS) break block6;
                for (i = 0; i < ILLEGAL_CHARS_WINDOWS.length; ++i) {
                    name = name.replace(ILLEGAL_CHARS_WINDOWS[i], '_');
                }
                break block7;
            }
            if (!SystemUtils.IS_OS_UNIX) break block7;
            for (i = 0; i < ILLEGAL_CHARS_UNIX.length; ++i) {
                name = name.replace(ILLEGAL_CHARS_UNIX[i], '_');
            }
        }
        return name;
    }
}

