/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.awt.Image;
import java.awt.PopupMenu;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NativeUtils.class);

    public static Process openUri(String uri) {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return NativeUtils.openSiteMac(uri);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return NativeUtils.openSiteWindows(uri);
        }
        return null;
    }

    private static Process openSiteMac(String siteUrl) {
        return NativeUtils.exec("open", siteUrl);
    }

    private static Process openSiteWindows(String siteUrl) {
        return NativeUtils.exec("cmd.exe", "/C", "start", siteUrl);
    }

    private static Process exec(String ... cmds) {
        ProcessBuilder pb = new ProcessBuilder(cmds);
        try {
            return pb.start();
        }
        catch (Exception e) {
            LOG.error("Could not open site", (Throwable)e);
            return null;
        }
    }

    public static void openFolder(File folder) throws IOException {
        if (!folder.isDirectory()) {
            LOG.warn("No directory at: {}", (Object)folder);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            Class[] argTypes = new Class[]{File.class};
            try {
                Class<?> desktopClass = Class.forName("java.awt.Desktop");
                Object obj = desktopClass.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                desktopClass.getDeclaredMethod("open", argTypes).invoke(obj, folder);
            }
            catch (Exception e) {
                LOG.error("Opening folder failed!!", (Throwable)e);
                if (SystemUtils.IS_OS_MAC_OSX) {
                    NativeUtils.exec("open", "'" + folder.getCanonicalPath() + "'");
                }
                throw new IOExceptionWithCause("Can't open folders on:" + SystemUtils.OS_NAME, (Throwable)e);
            }
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            try {
                String path = folder.getCanonicalPath();
                LOG.debug("Opening path: {}", (Object)path);
                Process process = NativeUtils.exec("open", path);
            }
            catch (IOException e) {
                LOG.error("Exception opening folder", (Throwable)e);
            }
        } else {
            LOG.debug("We don't know how to open folders on other OSes");
            throw new IOException("Can't open folders on:" + SystemUtils.OS_NAME);
        }
    }

    public static void addTray(Image image, String name, PopupMenu popup) {
        Class[] trayIconArgTypes = new Class[]{Image.class, String.class, PopupMenu.class};
        try {
            Class<?> trayIconClass = Class.forName("java.awt.TrayIcon");
            Constructor<?> trayIconConstructor = trayIconClass.getConstructor(trayIconArgTypes);
            Object trayIcon = trayIconConstructor.newInstance(image, name, popup);
            Class<?> trayClass = Class.forName("java.awt.SystemTray");
            Object obj = trayClass.getDeclaredMethod("getSystemTray", new Class[0]).invoke(null, new Object[0]);
            Class[] trayAddArgTypes = new Class[]{trayIconClass};
            trayClass.getDeclaredMethod("add", trayAddArgTypes).invoke(obj, trayIcon);
        }
        catch (Exception e) {
            LOG.warn("Reflection error", (Throwable)e);
        }
    }

    public static boolean supportsTray() {
        try {
            Class<?> trayClass = Class.forName("java.awt.SystemTray");
            Boolean bool = (Boolean)trayClass.getDeclaredMethod("isSupported", new Class[0]).invoke(null, new Object[0]);
            return bool;
        }
        catch (Exception e) {
            LOG.warn("Reflection error", (Throwable)e);
            return false;
        }
    }
}

