/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import org.apache.commons.lang.ClassUtils;
import org.littleshoot.util.Pair;

public class PairImpl<T1, T2>
implements Pair<T1, T2> {
    private final T1 m_first;
    private final T2 m_second;

    public PairImpl(T1 first, T2 second) {
        if (first == null) {
            throw new NullPointerException("Null first arg");
        }
        if (second == null) {
            throw new NullPointerException("Null second arg");
        }
        this.m_first = first;
        this.m_second = second;
    }

    @Override
    public T1 getFirst() {
        return this.m_first;
    }

    @Override
    public T2 getSecond() {
        return this.m_second;
    }

    public boolean equals(Object other) {
        if (other instanceof Pair) {
            Pair otherPair = (Pair)other;
            return otherPair.getFirst().equals(this.m_first) && otherPair.getSecond().equals(this.m_second);
        }
        return false;
    }

    public int hashCode() {
        int prime = 203249;
        return 203249 * this.m_first.hashCode() + 203249 * this.m_second.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassUtils.getShortClassName(this.getClass()));
        sb.append(" ");
        sb.append(this.m_first);
        sb.append(" ");
        sb.append(this.m_second);
        return sb.toString();
    }
}

