/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsRegistry.class);

    public static final int write(String key, String valueName, String valueData) {
        ProcessBuilder pb = new ProcessBuilder("reg", "add", "\"" + key + "\"", "/v", valueName, "/d", valueData);
        try {
            Process proc = pb.start();
            return proc.waitFor();
        }
        catch (IOException e) {
            LOG.error("Error writing to registry", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error("Error writing to registry", (Throwable)e);
        }
        return -1;
    }

    public static final String read(final String key, final String valueName) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + key + "\" /v " + valueName);
            final InputStream is = process.getInputStream();
            final StringWriter sw = new StringWriter();
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        int c;
                        while ((c = is.read()) != -1) {
                            sw.write(c);
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Error reading reg with key '" + key + "' and val '" + valueName + "'", (Throwable)e);
                    }
                }
            };
            Thread t = new Thread(runner, "Registry-Reading-Thread");
            t.setDaemon(true);
            t.start();
            process.waitFor();
            t.join();
            String output = sw.toString();
            Scanner scan = new Scanner(output);
            String lastValue = "";
            while (scan.hasNext()) {
                lastValue = scan.next();
            }
            return lastValue;
        }
        catch (IOException e) {
            LOG.error("Error reading reg with key '" + key + "' and val '" + valueName + "'", (Throwable)e);
            return "";
        }
        catch (InterruptedException e) {
            LOG.error("Error reading reg with key '" + key + "' and val '" + valueName + "'", (Throwable)e);
            return "";
        }
    }
}

