/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.util.Collection;
import java.util.LinkedList;
import org.littleshoot.util.Closure;
import org.littleshoot.util.None;
import org.littleshoot.util.NoneImpl;
import org.littleshoot.util.ObjectRefImpl;
import org.littleshoot.util.Optional;
import org.littleshoot.util.OptionalUtils;
import org.littleshoot.util.OptionalVisitor;
import org.littleshoot.util.Some;
import org.littleshoot.util.SomeImpl;
import org.littleshoot.util.Transformer;

public final class OptionalUtilsImpl
implements OptionalUtils {
    @Override
    public <T> void executeOnSome(Optional<T> optional, final Closure<T> closure) {
        OptionalVisitor visitor = new OptionalVisitor<Void, T>(){

            @Override
            public Void visitNone(None<T> none) {
                return null;
            }

            @Override
            public Void visitSome(Some<T> some) {
                closure.execute(some.object());
                return null;
            }
        };
        optional.accept(visitor);
    }

    @Override
    public <T> Collection<T> filterNones(Collection<Optional<T>> c) {
        final LinkedList result = new LinkedList();
        OptionalVisitor visitor = new OptionalVisitor<Void, T>(){

            @Override
            public Void visitNone(None<T> none) {
                return null;
            }

            @Override
            public Void visitSome(Some<T> some) {
                result.add(some.object());
                return null;
            }
        };
        for (Optional<T> current : c) {
            current.accept(visitor);
        }
        return result;
    }

    @Override
    public Optional optionalOf(Object object) {
        if (object == null) {
            return new NoneImpl();
        }
        return new SomeImpl<Object>(object);
    }

    @Override
    public <T1, T2> Optional<T2> transformSome(Optional<T1> optional, final Transformer<T1, T2> transformer) {
        OptionalVisitor visitor = new OptionalVisitor<Optional<T2>, T1>(){

            @Override
            public Optional<T2> visitNone(None<T1> none) {
                return new NoneImpl();
            }

            @Override
            public Optional<T2> visitSome(Some<T1> some) {
                Object original = some.object();
                Object transformed = transformer.transform(original);
                return new SomeImpl(transformed);
            }
        };
        return (Optional)optional.accept(visitor);
    }

    @Override
    public <T> boolean isNone(Optional<T> optional) {
        OptionalVisitor visitor = new OptionalVisitor<Boolean, T>(){

            @Override
            public Boolean visitNone(None<T> none) {
                return true;
            }

            @Override
            public Boolean visitSome(Some<T> some) {
                return false;
            }
        };
        return (Boolean)optional.accept(visitor);
    }

    @Override
    public boolean isSome(Optional optional) {
        return !this.isNone(optional);
    }

    @Override
    public <T> T someObject(Optional<T> optional) throws IllegalArgumentException {
        ObjectRefImpl objectRef = new ObjectRefImpl();
        OptionalVisitor visitor = new OptionalVisitor<T, T>(){

            @Override
            public T visitNone(None<T> none) {
                throw new IllegalArgumentException("Must be Some");
            }

            @Override
            public T visitSome(Some<T> some) {
                return some.object();
            }
        };
        return (T)optional.accept(visitor);
    }
}

