/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.commom.xmpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.security.auth.login.CredentialException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.lastbamboo.common.offer.answer.IceMediaStreamDesc;
import org.lastbamboo.common.offer.answer.NoAnswerException;
import org.lastbamboo.common.offer.answer.OfferAnswer;
import org.lastbamboo.common.offer.answer.OfferAnswerConnectException;
import org.lastbamboo.common.offer.answer.OfferAnswerFactory;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.lastbamboo.common.offer.answer.OfferAnswerMessage;
import org.lastbamboo.common.offer.answer.OfferAnswerTransactionListener;
import org.lastbamboo.common.offer.answer.Offerer;
import org.lastbamboo.common.p2p.DefaultTcpUdpEndpoint;
import org.lastbamboo.common.p2p.DefaultTcpUdpSocket;
import org.lastbamboo.common.p2p.P2PConnectionEvent;
import org.lastbamboo.common.p2p.P2PConnectionListener;
import org.lastbamboo.common.p2p.P2PConstants;
import org.lastbamboo.common.p2p.PortMappingState;
import org.lastbamboo.common.p2p.SocketType;
import org.littleshoot.commom.xmpp.PasswordCredentials;
import org.littleshoot.commom.xmpp.XmppCredentials;
import org.littleshoot.commom.xmpp.XmppP2PClient;
import org.littleshoot.commom.xmpp.XmppUtils;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.util.CommonUtils;
import org.littleshoot.util.FiveTuple;
import org.littleshoot.util.KeyStorage;
import org.littleshoot.util.PublicIp;
import org.littleshoot.util.SessionSocketListener;
import org.littleshoot.util.mina.MinaUtils;
import org.littleshoot.util.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ControlEndpointXmppP2PClient
implements XmppP2PClient<FiveTuple> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Long, TransactionData> transactionIdsToProcessors = new ConcurrentHashMap<Long, TransactionData>();
    private static final Map<String, Socket> incomingControlSockets = new ConcurrentHashMap<String, Socket>();
    private static final int TIMEOUT = 3600000;
    private final OfferAnswerFactory<FiveTuple> offerAnswerFactory;
    private final OfferAnswerFactory<Socket> socketOfferAnswerFactory;
    private XMPPConnection xmppConnection;
    private final Collection<MessageListener> messageListeners = new ArrayList<MessageListener>();
    private final int relayWaitTime;
    private String xmppServiceName;
    private final SessionSocketListener callSocketListener;
    private final InetSocketAddress plainTextRelayAddress;
    private static final ExecutorService exec = Executors.newCachedThreadPool(new ThreadFactory(){
        private AtomicInteger counter = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "ControlXmppP2PClient-Thread-Pool-" + this.counter.incrementAndGet());
            return thread;
        }
    });
    private final Map<URI, SSLSocket> outgoingControlSockets = new ConcurrentHashMap<URI, SSLSocket>();
    private final boolean useRelay;
    private final Set<String> sentMessageIds = new HashSet<String>();
    private final Map<URI, InetSocketAddress> urisToMappedServers = new ConcurrentHashMap<URI, InetSocketAddress>();
    private final PublicIp publicIp;
    private String xmppServerHost;
    private int xmppServerPort;
    private final SocketFactory socketFactory;
    private AtomicBoolean loggedOut = new AtomicBoolean(true);
    private OfferAnswerListener<FiveTuple> answererListener;
    private XmppCredentials credentials;
    private final AtomicInteger connectionAttempts = new AtomicInteger(0);
    private final AtomicBoolean connecting = new AtomicBoolean(false);
    private final Collection<P2PConnectionListener> listeners = new ArrayList<P2PConnectionListener>();

    public static ControlEndpointXmppP2PClient newGoogleTalkDirectClient(OfferAnswerFactory<FiveTuple> factory, OfferAnswerFactory<Socket> socketAnswerFactory, InetSocketAddress plainTextRelayAddress, SessionSocketListener callSocketListener, int relayWait, PublicIp publicIp, SocketFactory socketFactory, OfferAnswerListener<FiveTuple> answererListener) {
        return new ControlEndpointXmppP2PClient(factory, socketAnswerFactory, plainTextRelayAddress, callSocketListener, relayWait, "talk.google.com", 5222, "gmail.com", false, publicIp, socketFactory, answererListener);
    }

    public static ControlEndpointXmppP2PClient newClient(OfferAnswerFactory<FiveTuple> factory, OfferAnswerFactory<Socket> socketAnswerFactory, InetSocketAddress plainTextRelayAddress, SessionSocketListener callSocketListener, int relayWait, PublicIp publicIp, SocketFactory socketFactory, String host, int port, String serviceName, OfferAnswerListener<FiveTuple> answererListener) {
        return new ControlEndpointXmppP2PClient(factory, socketAnswerFactory, plainTextRelayAddress, callSocketListener, relayWait, host, port, serviceName, false, publicIp, socketFactory, answererListener);
    }

    private ControlEndpointXmppP2PClient(OfferAnswerFactory<FiveTuple> offerAnswerFactory, OfferAnswerFactory<Socket> socketAnswerFactory, InetSocketAddress plainTextRelayAddress, SessionSocketListener callSocketListener, int relayWaitTime, String host, int port, String serviceName, boolean useRelay, PublicIp publicIp, SocketFactory socketFactory, OfferAnswerListener<FiveTuple> answererListener) {
        this.offerAnswerFactory = offerAnswerFactory;
        this.socketOfferAnswerFactory = socketAnswerFactory;
        this.plainTextRelayAddress = plainTextRelayAddress;
        this.callSocketListener = callSocketListener;
        this.relayWaitTime = relayWaitTime;
        this.xmppServerHost = host;
        this.xmppServerPort = port;
        this.xmppServiceName = serviceName;
        this.useRelay = useRelay;
        this.publicIp = publicIp;
        this.socketFactory = socketFactory;
        this.answererListener = answererListener;
    }

    public FiveTuple newSocket(URI uri) throws IOException, NoAnswerException {
        this.log.trace("Creating XMPP socket for URI: {}", (Object)uri);
        if (this.useRelay) {
            return this.newSocket(uri, IceMediaStreamDesc.newReliable(), false);
        }
        return this.newSocket(uri, IceMediaStreamDesc.newReliableNoRelay(), false);
    }

    public FiveTuple newUnreliableSocket(URI uri) throws IOException, NoAnswerException {
        this.log.trace("Creating XMPP socket for URI: {}", (Object)uri);
        if (this.useRelay) {
            return this.newSocket(uri, IceMediaStreamDesc.newUnreliableUdpStream(), false);
        }
        return this.newSocket(uri, IceMediaStreamDesc.newUnreliableUdpStreamNoRelay(), false);
    }

    public FiveTuple newRawSocket(URI uri) throws IOException, NoAnswerException {
        this.log.trace("Creating XMPP socket for URI: {}", (Object)uri);
        if (this.useRelay) {
            return this.newSocket(uri, IceMediaStreamDesc.newReliable(), true);
        }
        return this.newSocket(uri, IceMediaStreamDesc.newReliableNoRelay(), true);
    }

    public FiveTuple newRawUnreliableSocket(URI uri) throws IOException, NoAnswerException {
        this.log.trace("Creating XMPP socket for URI: {}", (Object)uri);
        if (this.useRelay) {
            return this.newSocket(uri, IceMediaStreamDesc.newUnreliableUdpStream(), true);
        }
        return this.newSocket(uri, IceMediaStreamDesc.newUnreliableUdpStreamNoRelay(), true);
    }

    private FiveTuple newSocket(URI uri, IceMediaStreamDesc streamDesc, boolean raw) throws IOException, NoAnswerException {
        this.log.trace("Creating XMPP socket for URI: {}", (Object)uri);
        String us = this.xmppConnection.getUser().trim();
        this.log.trace("Our JID is: " + us);
        if (us.equals(uri.toASCIIString())) {
            this.log.info("Not connecting to ourselves.");
            throw new IOException("Not connecting to ourselves: " + us);
        }
        if (streamDesc.isTcp() && this.urisToMappedServers.containsKey(uri)) {
            this.log.info("USING MAPPED PORT SERVER!");
            return this.newConnectionToMappedServerSocket(uri, raw);
        }
        SSLSocket control = this.controlSocket(uri, streamDesc);
        if (streamDesc.isTcp() && this.urisToMappedServers.containsKey(uri) && control instanceof SSLSocket) {
            this.log.info("USING MAPPED PORT SERVER AFTER CONTROL!");
            IOUtils.closeQuietly((Socket)control);
            return this.newConnectionToMappedServerSocket(uri, raw);
        }
        DefaultTcpUdpEndpoint tcpUdpSocket = new DefaultTcpUdpEndpoint((Offerer)new OffererOverControlSocket(control, streamDesc), this.offerAnswerFactory, this.relayWaitTime, 20000L, streamDesc);
        this.log.info("Trying to create new socket...raw=" + raw);
        FiveTuple sock = tcpUdpSocket.newSocket(uri);
        return sock;
    }

    private FiveTuple newConnectionToMappedServerSocket(URI uri, boolean raw) throws IOException {
        InetSocketAddress serverIp = this.urisToMappedServers.get(uri);
        return new FiveTuple(null, serverIp, FiveTuple.Protocol.TCP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocket controlSocket(URI uri, IceMediaStreamDesc streamDesc) throws IOException, NoAnswerException {
        Map<URI, SSLSocket> map = this.outgoingControlSockets;
        synchronized (map) {
            if (!this.outgoingControlSockets.containsKey(uri)) {
                this.log.info("Creating new control socket");
                SSLSocket control = this.establishControlSocket(uri, streamDesc);
                return control;
            }
            this.log.info("Using existing control socket");
            SSLSocket control = this.outgoingControlSockets.get(uri);
            if (!control.isClosed()) {
                return control;
            }
            this.log.info("Establishing new control socket because control socket is closed!");
            SSLSocket newControl = this.establishControlSocket(uri, streamDesc);
            return newControl;
        }
    }

    private void notifyConnectionListeners(URI jid, Socket sock, boolean incoming, boolean connected, PortMappingState mappingState, SocketType socketType) {
        this.notifyConnectionListeners(jid.toASCIIString(), sock, incoming, connected, mappingState, socketType);
    }

    private void notifyConnectionListeners(final String jid, final Socket sock, final boolean incoming, final boolean connected, final PortMappingState mappingState, final SocketType socketType) {
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                P2PConnectionEvent event = new P2PConnectionEvent(jid, sock, incoming, connected, mappingState, socketType);
                Collection collection = ControlEndpointXmppP2PClient.this.listeners;
                synchronized (collection) {
                    for (P2PConnectionListener listener : ControlEndpointXmppP2PClient.this.listeners) {
                        listener.onConnectivityEvent(event);
                    }
                }
            }
        };
        exec.execute(runner);
    }

    private SSLSocket establishControlSocket(URI uri, IceMediaStreamDesc streamDesc) throws IOException, NoAnswerException {
        DefaultTcpUdpSocket tcpUdpSocket = new DefaultTcpUdpSocket((Offerer)this, this.socketOfferAnswerFactory, this.relayWaitTime, 30000L, streamDesc);
        Socket rawSock = tcpUdpSocket.newSocket(uri);
        this.log.debug("Raw sock class: {}", rawSock.getClass());
        SSLSocket sock = (SSLSocket)rawSock;
        sock.setSoTimeout(3600000);
        this.log.debug("Control socket cipher suites: {}", Arrays.asList(sock.getEnabledCipherSuites()));
        this.log.debug("Created control socket: {}", (Object)sock);
        this.notifyConnectionListeners(uri, (Socket)sock, false, true, PortMappingState.UNKNOWN, SocketType.UNKNOWN);
        this.outgoingControlSockets.put(uri, sock);
        return sock;
    }

    public String login(String user, String pass) throws IOException, CredentialException {
        return this.login(user, pass, "SHOOT-");
    }

    @Override
    public String login(String user, String pass, String serverHost, int serverPort, String serviceName) throws IOException, CredentialException {
        return this.login(user, pass, serverHost, serverPort, serviceName, "SHOOT-");
    }

    public String login(String user, String pass, String id) throws IOException, CredentialException {
        return this.login(user, pass, this.xmppServerHost, this.xmppServerPort, this.xmppServiceName, id);
    }

    @Override
    public String login(String user, String pass, String serverHost, int serverPort, String serviceName, String id) throws CredentialException, IOException {
        return this.login(new PasswordCredentials(user, pass, id), serverHost, serverPort, serviceName);
    }

    @Override
    public String login(XmppCredentials creds) throws CredentialException, IOException {
        return this.login(creds, this.xmppServerHost, this.xmppServerPort, this.xmppServiceName);
    }

    @Override
    public String login(XmppCredentials creds, String serverHost, int serverPort, String serviceName) throws CredentialException, IOException {
        if (this.connecting.get()) {
            throw new IOException("Already attempting connection");
        }
        this.loggedOut.set(false);
        this.credentials = creds;
        this.xmppServerHost = serverHost;
        if ("talk.google.com".equals(this.xmppServerHost)) {
            this.xmppServerPort = 5222;
            this.xmppServiceName = "gmail.com";
        } else {
            this.xmppServerPort = serverPort;
            this.xmppServiceName = serviceName;
        }
        int att = this.connectionAttempts.incrementAndGet();
        int retries = 100 - att;
        if (retries < 1) {
            throw new IOException("Already reached maximum number of attempts");
        }
        this.connecting.set(true);
        try {
            this.xmppConnection = XmppUtils.persistentXmppConnection(creds, retries, this.xmppServerHost, this.xmppServerPort, this.xmppServiceName, this);
        }
        catch (CredentialException e) {
            this.connecting.set(false);
            throw e;
        }
        catch (IOException e) {
            this.connecting.set(false);
            throw e;
        }
        this.connecting.set(false);
        this.processMessages();
        return this.xmppConnection.getUser();
    }

    public void offer(URI uri, byte[] offer, OfferAnswerTransactionListener transactionListener, KeyStorage keyStorage) throws IOException {
        String jid = uri.toASCIIString();
        Message offerMessage = this.newInviteToEstablishControlSocket(jid, offer, transactionListener, keyStorage);
        XmppUtils.goOffTheRecord(jid, this.xmppConnection);
        this.xmppConnection.sendPacket((Packet)offerMessage);
    }

    private Message newInviteToEstablishControlSocket(String jid, byte[] offer, OfferAnswerTransactionListener transactionListener, KeyStorage keyStorage) {
        long id = RandomUtils.nextLong();
        this.transactionIdsToProcessors.put(id, new TransactionData(transactionListener, keyStorage));
        Message msg = new Message();
        msg.setTo(jid);
        this.log.info("Sending offer: {}", (Object)new String(offer));
        String base64Sdp = Base64.encodeBase64URLSafeString((byte[])offer);
        msg.setProperty("TID", (Object)id);
        msg.setProperty(P2PConstants.MESSAGE_TYPE, (Object)1);
        msg.setProperty("S", (Object)base64Sdp);
        msg.setProperty("C", (Object)"true");
        return msg;
    }

    private void processMessages() {
        PacketTypeFilter filter = new PacketTypeFilter(Message.class);
        PacketListener myListener = new PacketListener(){

            public void processPacket(Packet packet) {
                Message msg = (Message)packet;
                String id = msg.getPacketID();
                ControlEndpointXmppP2PClient.this.log.info("Checking message ID: {}", (Object)id);
                if (ControlEndpointXmppP2PClient.this.loggedOut.get()) {
                    ControlEndpointXmppP2PClient.this.log.warn("Got a message while logged out?");
                    return;
                }
                if (ControlEndpointXmppP2PClient.this.sentMessageIds.contains(id)) {
                    ControlEndpointXmppP2PClient.this.log.warn("Message is from us!!");
                    Message error = ControlEndpointXmppP2PClient.this.newError(msg);
                    ControlEndpointXmppP2PClient.this.xmppConnection.sendPacket((Packet)error);
                } else {
                    exec.execute(new PacketProcessor(msg));
                }
            }
        };
        this.xmppConnection.addPacketListener(myListener, (PacketFilter)filter);
    }

    protected Message newError(Message msg) {
        return this.newError(msg.getFrom(), (Long)msg.getProperty("TID"));
    }

    protected Message newError(String from, Long tid) {
        Message error = new Message();
        error.setProperty(P2PConstants.MESSAGE_TYPE, (Object)16);
        if (tid != null) {
            error.setProperty("TID", (Object)tid);
        }
        error.setTo(from);
        return error;
    }

    private void processInviteToEstablishControlSocket(Message msg) {
        OfferAnswer offerAnswer;
        String sdp = (String)msg.getProperty("S");
        ByteBuffer offer = ByteBuffer.wrap((byte[])Base64.decodeBase64((String)sdp));
        String offerString = MinaUtils.toAsciiString((ByteBuffer)offer);
        this.log.info("Processing offer: {}", (Object)offerString);
        try {
            offerAnswer = this.socketOfferAnswerFactory.createAnswerer((OfferAnswerListener)new ControlSocketOfferAnswerListener(msg.getFrom()), false);
        }
        catch (OfferAnswerConnectException e) {
            this.log.warn("We could not create candidates for offer: " + sdp, (Throwable)e);
            Message error = this.newError(msg);
            this.xmppConnection.sendPacket((Packet)error);
            return;
        }
        byte[] answer = offerAnswer.generateAnswer();
        long tid = (Long)msg.getProperty("TID");
        Message inviteOk = this.newInviteOk(tid, answer);
        String to = msg.getFrom();
        inviteOk.setTo(to);
        this.log.info("Sending CONTROL INVITE OK to {}", (Object)inviteOk.getTo());
        XmppUtils.goOffTheRecord(to, this.xmppConnection);
        this.xmppConnection.sendPacket((Packet)inviteOk);
        offerAnswer.processOffer(offer);
        this.log.debug("Done processing CONTROL XMPP INVITE!!!");
    }

    private Message newInviteOk(Long tid, byte[] answer) {
        Message inviteOk = new Message();
        if (tid != null) {
            inviteOk.setProperty("TID", (Object)tid);
        }
        inviteOk.setProperty(P2PConstants.MESSAGE_TYPE, (Object)4);
        inviteOk.setProperty("S", (Object)Base64.encodeBase64String((byte[])answer));
        if (this.offerAnswerFactory.isAnswererPortMapped()) {
            inviteOk.setProperty("MP", (Object)this.offerAnswerFactory.getMappedPort());
            inviteOk.setProperty("PI", (Object)this.publicIp.getPublicIpAddress().getHostAddress());
        }
        return inviteOk;
    }

    private void processInviteOverControlSocket(final ByteBuffer offer, Socket controlSocket, String from) throws IOException {
        OfferAnswer offerAnswer;
        this.log.info("Processing offer...");
        String offerString = MinaUtils.toAsciiString((ByteBuffer)offer);
        try {
            offerAnswer = this.offerAnswerFactory.createAnswerer(this.answererListener, this.useRelay);
        }
        catch (OfferAnswerConnectException e) {
            this.log.warn("We could not create candidates for offer", (Throwable)e);
            this.error(from, null, controlSocket);
            return;
        }
        this.log.info("Creating answer");
        byte[] answer = offerAnswer.generateAnswer();
        this.log.info("Creating INVITE OK");
        Message inviteOk = this.newInviteOk(null, answer);
        this.log.info("Writing INVITE OK");
        this.writeMessage(inviteOk, controlSocket);
        this.log.info("Wrote INVITE OK");
        exec.submit(new Runnable(){

            @Override
            public void run() {
                ControlEndpointXmppP2PClient.this.log.info("Passing offer processing to listener...");
                offerAnswer.processOffer(offer);
            }
        });
        this.log.info("Done processing offer...");
    }

    private void closeOutgoing(URI uri, Socket control) {
        this.notifyConnectionListeners(uri, control, false, false, PortMappingState.UNKNOWN, SocketType.UNKNOWN);
        IOUtils.closeQuietly((Socket)control);
        this.outgoingControlSockets.remove(uri);
    }

    @Override
    public XMPPConnection getXmppConnection() {
        return this.xmppConnection;
    }

    @Override
    public void addMessageListener(MessageListener ml) {
        this.messageListeners.add(ml);
    }

    private void error(String from, Long tid, Socket sock) {
        Message error = this.newError(from, tid);
        try {
            this.writeMessage(error, sock);
        }
        catch (IOException e) {
            this.log.warn("Could not write message", (Throwable)e);
        }
    }

    private void writeMessage(Message msg, Socket sock) throws IOException {
        this.log.info("Sending message through socket: {}", (Object)sock);
        String msgString = this.toXml(msg);
        this.log.info("Writing XMPP message: {}", (Object)msgString);
        OutputStream os = sock.getOutputStream();
        this.log.info("Writing message to output stream: {}", (Object)os);
        os.write(msgString.getBytes("UTF-8"));
        os.flush();
    }

    private String toXml(Message msg) {
        return msg.toXML() + "\n";
    }

    public void logout() {
        this.loggedOut.set(true);
        if (this.xmppConnection != null) {
            this.xmppConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(P2PConnectionListener listener) {
        Collection<P2PConnectionListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean isLoggedOut() {
        return this.loggedOut.get();
    }

    @Override
    public void handleClose() {
        if (this.isLoggedOut()) {
            this.log.info("Not maintaining connection because the user is logged out, possibly due to a stop call on internet disconnect.");
            return;
        }
        try {
            this.login(this.credentials);
            if (this.callSocketListener != null) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ControlEndpointXmppP2PClient.this.callSocketListener.reconnected();
                    }
                }, "Reconnected-Listener-Thread");
                t.setDaemon(true);
                t.start();
            }
        }
        catch (IOException e) {
            this.log.info("Could not connect!!");
        }
        catch (CredentialException e) {
            this.log.info("Credentials are wrong!", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.logout();
        this.xmppConnection.disconnect();
    }

    private final class ControlSocketOfferAnswerListener
    implements OfferAnswerListener<Socket> {
        private final String fullJid;

        public ControlSocketOfferAnswerListener(String fullJid) {
            ControlEndpointXmppP2PClient.this.log.debug("Creating listener on answerwer with full JID: {}", (Object)fullJid);
            this.fullJid = fullJid;
        }

        public void onOfferAnswerFailed(OfferAnswer offerAnswer) {
            ControlEndpointXmppP2PClient.this.log.debug("TCP or UDP offer answer failed: {}", (Object)offerAnswer);
        }

        public void onTcpSocket(Socket sock) {
            ControlEndpointXmppP2PClient.this.log.debug("Got a TCP socket: {}", (Object)sock);
            this.onControlSocket(sock);
        }

        public void onUdpSocket(Socket sock) {
            ControlEndpointXmppP2PClient.this.log.debug("Got a UDP socket: {}", (Object)sock);
            this.onControlSocket(sock);
        }

        private void onControlSocket(Socket tuple) {
            ControlEndpointXmppP2PClient.this.log.debug("Got control socket on 'server' side: {}", (Object)tuple);
            incomingControlSockets.put(this.fullJid, tuple);
            try {
                this.readInvites(tuple);
            }
            catch (IOException e) {
                ControlEndpointXmppP2PClient.this.log.info("Exception reading invites - this will happen whenever the other side closes the connection, which will happen all the time.", (Throwable)e);
                incomingControlSockets.remove(this.fullJid);
            }
            catch (SAXException e) {
                ControlEndpointXmppP2PClient.this.log.info("Exception reading invites", (Throwable)e);
                incomingControlSockets.remove(this.fullJid);
            }
        }

        private void readInvites(Socket sock) throws IOException, SAXException {
            ControlEndpointXmppP2PClient.this.log.debug("Got control tuple!!");
            InputStream is = sock.getInputStream();
            ControlEndpointXmppP2PClient.this.log.debug("Reading streams from remote address: {}", (Object)sock.getRemoteSocketAddress());
            ControlEndpointXmppP2PClient.this.log.debug("Reading answerer invites on input stream: {}", (Object)is);
            while (true) {
                ControlEndpointXmppP2PClient.this.log.debug("Trying to read next offer on control socket...");
                Document doc = XmlUtils.toDoc((InputStream)is, (String)"</message>");
                ControlEndpointXmppP2PClient.this.log.info("Got XML INVITE: {}", (Object)XmlUtils.toString((Document)doc));
                String sdp = XmppUtils.extractSdp(doc);
                String from = XmppUtils.extractFrom(doc);
                ByteBuffer offer = ByteBuffer.wrap((byte[])Base64.decodeBase64((String)sdp));
                ControlEndpointXmppP2PClient.this.processInviteOverControlSocket(offer, sock, from);
            }
        }
    }

    private class OffererOverControlSocket
    implements Offerer {
        private SSLSocket control;
        private final IceMediaStreamDesc streamDesc;

        private OffererOverControlSocket(SSLSocket control, IceMediaStreamDesc streamDesc) {
            this.control = control;
            this.streamDesc = streamDesc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void offer(URI uri, byte[] offer, OfferAnswerTransactionListener transactionListener, KeyStorage keyStore) {
            ControlEndpointXmppP2PClient.this.log.info("Sending message from local address: {}", (Object)this.control.getLocalSocketAddress());
            SSLSocket sSLSocket = this.control;
            synchronized (sSLSocket) {
                ControlEndpointXmppP2PClient.this.log.info("Got lock on control socket...");
                Message msg = this.newInviteOverControlSocket(uri.toASCIIString(), offer, keyStore);
                String xml = ControlEndpointXmppP2PClient.this.toXml(msg);
                ControlEndpointXmppP2PClient.this.log.info("Writing XML offer on control socket: {}", (Object)xml);
                try {
                    this.writeToControlSocket(xml);
                }
                catch (SSLHandshakeException e) {
                    ControlEndpointXmppP2PClient.this.log.warn("SSL error creating control socket? Try:System.setProperty(\"javax.net.debug\", \"ssl:record\");", (Throwable)e);
                    ControlEndpointXmppP2PClient.this.closeOutgoing(uri, this.control);
                }
                catch (IOException e) {
                    ControlEndpointXmppP2PClient.this.closeOutgoing(uri, this.control);
                    ControlEndpointXmppP2PClient.this.log.debug("Control socket timed out? We'll try to establish a new one", (Throwable)e);
                    try {
                        this.control = ControlEndpointXmppP2PClient.this.establishControlSocket(uri, this.streamDesc);
                        this.writeToControlSocket(xml);
                    }
                    catch (IOException ioe) {
                        ControlEndpointXmppP2PClient.this.log.warn("Still could not establish or write to new control socket -- try -Djavax.net.debug=ssl:record or System.setProperty(\"javax.net.debug\", \"ssl:record\");", (Throwable)ioe);
                        ControlEndpointXmppP2PClient.this.closeOutgoing(uri, this.control);
                        return;
                    }
                    catch (NoAnswerException nae) {
                        ControlEndpointXmppP2PClient.this.log.warn("Still could not establish or write to new control socket -- try -Djavax.net.debug=ssl:record or System.setProperty(\"javax.net.debug\", \"ssl:record\");", (Throwable)nae);
                        ControlEndpointXmppP2PClient.this.closeOutgoing(uri, this.control);
                        return;
                    }
                }
                try {
                    InputStream is = this.control.getInputStream();
                    ControlEndpointXmppP2PClient.this.log.info("Reading incoming answer on control socket");
                    Document doc = XmlUtils.toDoc((InputStream)is, (String)"</message>");
                    String received = XmlUtils.toString((Document)doc);
                    ControlEndpointXmppP2PClient.this.log.info("Got INVITE OK on CONTROL socket: {}", (Object)received);
                    String sdp = XmppUtils.extractSdp(doc);
                    final byte[] sdpBytes = Base64.decodeBase64((String)sdp);
                    OfferAnswerMessage message = new OfferAnswerMessage(){

                        public String getTransactionKey() {
                            return String.valueOf(this.hashCode());
                        }

                        public ByteBuffer getBody() {
                            return ByteBuffer.wrap((byte[])sdpBytes);
                        }
                    };
                    ControlEndpointXmppP2PClient.this.log.info("Calling transaction succeeded on listener: {}", (Object)transactionListener);
                    transactionListener.onTransactionSucceeded(message);
                }
                catch (SAXException e) {
                    ControlEndpointXmppP2PClient.this.log.warn("Could not parse INVITE OK", (Throwable)e);
                    ControlEndpointXmppP2PClient.this.closeOutgoing(uri, this.control);
                }
                catch (IOException e) {
                    ControlEndpointXmppP2PClient.this.log.warn("Exception handling control socket", (Throwable)e);
                    ControlEndpointXmppP2PClient.this.closeOutgoing(uri, this.control);
                }
            }
        }

        private Message newInviteOverControlSocket(String jid, byte[] offer, KeyStorage keyStorage) {
            Message msg = new Message();
            msg.setTo(jid);
            ControlEndpointXmppP2PClient.this.log.info("Sending offer: {}", (Object)new String(offer));
            String base64Sdp = Base64.encodeBase64URLSafeString((byte[])offer);
            msg.setProperty(P2PConstants.MESSAGE_TYPE, (Object)1);
            msg.setProperty("S", (Object)base64Sdp);
            msg.setProperty("C", (Object)"true");
            return msg;
        }

        private void writeToControlSocket(String xml) throws IOException {
            OutputStream os = this.control.getOutputStream();
            os.write(xml.getBytes("UTF-8"));
            os.flush();
            ControlEndpointXmppP2PClient.this.log.info("Wrote message on control socket stream: {}", (Object)os);
        }
    }

    private final class PacketProcessor
    implements Runnable {
        private final Message msg;

        private PacketProcessor(Message msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            ControlEndpointXmppP2PClient.this.log.info("Got message from {}", (Object)this.msg.getFrom());
            Object obj = this.msg.getProperty(P2PConstants.MESSAGE_TYPE);
            if (obj == null) {
                ControlEndpointXmppP2PClient.this.log.info("No message type!! Notifying listeners");
                this.notifyListeners();
                return;
            }
            int mt = (Integer)obj;
            switch (mt) {
                case 1: {
                    ControlEndpointXmppP2PClient.this.log.info("Processing CONTROL INVITE");
                    ControlEndpointXmppP2PClient.this.processInviteToEstablishControlSocket(this.msg);
                    break;
                }
                case 4: {
                    ControlEndpointXmppP2PClient.this.log.info("Got INVITE_OK");
                    TransactionData okTd = this.toTransactionData();
                    if (okTd == null) {
                        ControlEndpointXmppP2PClient.this.log.error("No matching transaction ID?");
                        break;
                    }
                    ControlEndpointXmppP2PClient.this.log.info("Got transaction data!!");
                    OfferAnswerMessage oam = this.toOfferAnswerMessage(okTd);
                    this.addMappedServer();
                    okTd.transactionListener.onTransactionSucceeded(oam);
                    break;
                }
                case 16: {
                    ControlEndpointXmppP2PClient.this.log.info("Got INVITE_ERROR - transaction failed");
                    TransactionData eTd = this.toTransactionData();
                    if (eTd == null) {
                        ControlEndpointXmppP2PClient.this.log.error("No matching transaction ID?");
                        break;
                    }
                    OfferAnswerMessage oam = this.toOfferAnswerMessage(eTd);
                    eTd.transactionListener.onTransactionFailed(oam);
                    break;
                }
                default: {
                    ControlEndpointXmppP2PClient.this.log.info("Non-standard message on aswerer...sending to additional listeners, if any: " + mt);
                    this.notifyListeners();
                }
            }
        }

        private TransactionData toTransactionData() {
            Long id = (Long)this.msg.getProperty("TID");
            return (TransactionData)ControlEndpointXmppP2PClient.this.transactionIdsToProcessors.remove(id);
        }

        private OfferAnswerMessage toOfferAnswerMessage(TransactionData td) {
            final byte[] body = CommonUtils.decodeBase64((String)((String)this.msg.getProperty("S")));
            return new OfferAnswerMessage(){

                public String getTransactionKey() {
                    return String.valueOf(this.hashCode());
                }

                public ByteBuffer getBody() {
                    return ByteBuffer.wrap((byte[])body);
                }
            };
        }

        private boolean addMappedServer() {
            Integer port;
            String remoteIp = (String)this.msg.getProperty("PI");
            ControlEndpointXmppP2PClient.this.log.info("Got public IP address: {}", (Object)remoteIp);
            if (StringUtils.isNotBlank((String)remoteIp) && (port = (Integer)this.msg.getProperty("MP")) != null) {
                InetSocketAddress mapped = new InetSocketAddress(remoteIp, (int)port);
                ControlEndpointXmppP2PClient.this.log.info("ADDING MAPPED SERVER PORT!!");
                try {
                    ControlEndpointXmppP2PClient.this.urisToMappedServers.put(new URI(this.msg.getFrom()), mapped);
                }
                catch (URISyntaxException e) {
                    ControlEndpointXmppP2PClient.this.log.error("Bad URI?", (Object)this.msg.getFrom());
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners() {
            ControlEndpointXmppP2PClient.this.log.info("Notifying global listeners");
            Collection collection = ControlEndpointXmppP2PClient.this.messageListeners;
            synchronized (collection) {
                if (ControlEndpointXmppP2PClient.this.messageListeners.isEmpty()) {
                    ControlEndpointXmppP2PClient.this.log.info("No message listeners to forward to");
                }
                for (MessageListener ml : ControlEndpointXmppP2PClient.this.messageListeners) {
                    ml.processMessage(null, this.msg);
                }
            }
        }

        public String toString() {
            return "INVITE Runner for Chat with: " + this.msg.getFrom();
        }
    }

    private final class TransactionData {
        private final OfferAnswerTransactionListener transactionListener;

        private TransactionData(OfferAnswerTransactionListener transactionListener, KeyStorage keyStorage) {
            this.transactionListener = transactionListener;
        }
    }
}

