/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.commom.xmpp;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.lang.StringUtils;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.littleshoot.commom.xmpp.XmppCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleOAuth2Credentials
implements XmppCredentials,
CallbackHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String username;
    private final String resource;
    private final String clientID;
    private final String clientSecret;
    private final String accessToken;
    private final String refreshToken;

    public GoogleOAuth2Credentials(String username, String clientID, String clientSecret, String accessToken, String refreshToken) {
        this(username, clientID, clientSecret, accessToken, refreshToken, "SHOOT-");
    }

    public GoogleOAuth2Credentials(String username, String clientID, String clientSecret, String accessToken, String refreshToken, String resource) {
        this.username = StringUtils.isNotBlank((String)username) && !username.contains("@") ? username + "@gmail.com" : username;
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.resource = resource;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getKey() {
        return this.username + this.refreshToken;
    }

    @Override
    public XMPPConnection createConnection(ConnectionConfiguration config) {
        config.setCallbackHandler((CallbackHandler)this);
        XMPPConnection conn = new XMPPConnection(config);
        SASLAuthentication.supportSASLMechanism((String)"X-OAUTH2");
        return conn;
    }

    @Override
    public void login(XMPPConnection conn) throws XMPPException {
        conn.login(this.username, null, this.resource);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            if (cb instanceof TextInputCallback) {
                TextInputCallback ticb = (TextInputCallback)cb;
                String prompt = ticb.getPrompt();
                this.log.info("Got prompt: {}", (Object)prompt);
                if (prompt == "clientID") {
                    ticb.setText(this.clientID);
                    continue;
                }
                if (prompt == "clientSecret") {
                    ticb.setText(this.clientSecret);
                    continue;
                }
                if (prompt == "accessToken") {
                    ticb.setText(this.accessToken);
                    continue;
                }
                if (prompt == "refreshToken") {
                    ticb.setText(this.refreshToken);
                    continue;
                }
                throw new UnsupportedCallbackException(ticb, "Unrecognized prompt: " + ticb.getPrompt());
            }
            throw new UnsupportedCallbackException(cb, "Unsupported callback type.");
        }
    }

    public String toString() {
        return "GoogleOAuth2Credentials [username=" + this.username + ", resource=" + this.resource + ", clientID=" + this.clientID + ", clientSecret=" + this.clientSecret + ", accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + "]";
    }
}

