/*
 * Decompiled with CFR 0.152.
 */
package org.liurb.ai.sdk.gemini;

import com.alibaba.fastjson2.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.liurb.ai.sdk.gemini.bean.Candidate;
import org.liurb.ai.sdk.gemini.bean.ChatHistory;
import org.liurb.ai.sdk.gemini.bean.ChatMultiHistory;
import org.liurb.ai.sdk.gemini.bean.ChatTextMessage;
import org.liurb.ai.sdk.gemini.bean.Content;
import org.liurb.ai.sdk.gemini.bean.GenerationConfig;
import org.liurb.ai.sdk.gemini.bean.MediaPart;
import org.liurb.ai.sdk.gemini.bean.MultiPartInlineData;
import org.liurb.ai.sdk.gemini.bean.TextPart;
import org.liurb.ai.sdk.gemini.conf.GeminiAccount;
import org.liurb.ai.sdk.gemini.dto.GeminiTextRequest;
import org.liurb.ai.sdk.gemini.dto.GeminiTextResponse;
import org.liurb.ai.sdk.gemini.enums.GeminiModelEnum;
import org.liurb.ai.sdk.gemini.listener.StreamResponseListener;

public class GeminiClient {
    private GeminiAccount geminiAccount;
    private String BASE_URL = "https://generativelanguage.googleapis.com";
    private String MODEL_NAME = GeminiModelEnum.GEMINI_PRO_FLASH.getName();
    private OkHttpClient okHttpClient;
    private List<ChatHistory> history;
    private static final ConnectionPool sharedConnectionPool = new ConnectionPool(32, 60L, TimeUnit.SECONDS);

    private GeminiClient() {
    }

    public GeminiClient(GeminiAccount geminiAccount) {
        this.geminiAccount = geminiAccount;
        this.okHttpClient = this.defaultClient();
        this.history = new ArrayList<ChatHistory>();
    }

    public GeminiClient(String modelName, GeminiAccount geminiAccount) {
        this.geminiAccount = geminiAccount;
        this.okHttpClient = this.defaultClient();
        this.MODEL_NAME = modelName;
        this.history = new ArrayList<ChatHistory>();
    }

    public GeminiClient(GeminiAccount geminiAccount, OkHttpClient okHttpClient) {
        this.geminiAccount = geminiAccount;
        this.okHttpClient = okHttpClient;
        this.history = new ArrayList<ChatHistory>();
    }

    public GeminiClient(String modelName, GeminiAccount geminiAccount, OkHttpClient okHttpClient) {
        this.geminiAccount = geminiAccount;
        this.okHttpClient = okHttpClient;
        this.MODEL_NAME = modelName;
        this.history = new ArrayList<ChatHistory>();
    }

    public GeminiTextResponse chat(String message) throws IOException {
        return this.chat(message, null, null);
    }

    public GeminiTextResponse chat(String message, GenerationConfig generationConfig) throws IOException {
        return this.chat(message, null, generationConfig);
    }

    public GeminiTextResponse chat(String message, MultiPartInlineData inlineData, GenerationConfig generationConfig) throws IOException {
        if (this.geminiAccount == null || this.geminiAccount.getApiKey() == null || this.geminiAccount.getApiKey().isEmpty()) {
            throw new RuntimeException("gemini api key is empty");
        }
        if (this.geminiAccount.getBaseUrl() != null && !this.geminiAccount.getBaseUrl().isEmpty()) {
            this.BASE_URL = this.geminiAccount.getBaseUrl();
        }
        GeminiTextRequest questParams = this.buildGeminiTextRequest(message, inlineData, this.history);
        if (generationConfig != null) {
            questParams.setGenerationConfig(generationConfig);
        }
        MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)json, (String)JSON.toJSONString((Object)questParams));
        String url = "{base_url}/v1/{model}:generateContent?key={api_key}";
        Request request = new Request.Builder().url(url = url.replace("{base_url}", this.BASE_URL).replace("{api_key}", this.geminiAccount.getApiKey()).replace("{model}", this.MODEL_NAME)).post(requestBody).build();
        Response response = this.okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            String responseBody = response.body().string();
            GeminiTextResponse textResponse = (GeminiTextResponse)JSON.parseObject((String)responseBody, GeminiTextResponse.class);
            textResponse.setHistory(this.buildChatHistory(message, inlineData, textResponse.getCandidates(), this.history));
            return textResponse;
        }
        return null;
    }

    public void stream(final String message, final MultiPartInlineData inlineData, GenerationConfig generationConfig, final StreamResponseListener responseListener) throws IOException {
        if (this.geminiAccount == null || this.geminiAccount.getApiKey() == null || this.geminiAccount.getApiKey().isEmpty()) {
            throw new RuntimeException("gemini api key is empty");
        }
        if (this.geminiAccount.getBaseUrl() != null && !this.geminiAccount.getBaseUrl().isEmpty()) {
            this.BASE_URL = this.geminiAccount.getBaseUrl();
        }
        GeminiTextRequest questParams = this.buildGeminiTextRequest(message, inlineData, this.history);
        if (generationConfig != null) {
            questParams.setGenerationConfig(generationConfig);
        }
        MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)json, (String)JSON.toJSONString((Object)questParams));
        String url = "{base_url}/v1/{model}:streamGenerateContent?key={api_key}&alt=sse";
        url = url.replace("{base_url}", this.BASE_URL).replace("{api_key}", this.geminiAccount.getApiKey()).replace("{model}", this.MODEL_NAME);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    try (ResponseBody responseBody = response.body();){
                        String line;
                        StringBuffer textSb = new StringBuffer();
                        InputStream inputStream = responseBody.byteStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((line = reader.readLine()) != null) {
                            if (!(line = line.trim()).startsWith("data: ")) continue;
                            line = line.substring("data: ".length());
                            GeminiTextResponse streamResponse = (GeminiTextResponse)JSON.parseObject((String)line, GeminiTextResponse.class);
                            Content content = streamResponse.getCandidates().get(0).getContent();
                            textSb.append(content.getParts().get(0).getText());
                            responseListener.accept(content);
                        }
                        GeminiClient.this.buildStreamChatHistory(message, inlineData, textSb, GeminiClient.this.history);
                    }
                }
            }
        });
    }

    private GeminiTextRequest buildGeminiTextRequest(String message, MultiPartInlineData inlineData, List<ChatHistory> history) {
        ArrayList<ChatTextMessage> contents = new ArrayList<ChatTextMessage>();
        if (history != null && !history.isEmpty()) {
            for (ChatHistory chat : history) {
                if (chat instanceof ChatMultiHistory) {
                    ChatMultiHistory chatMultiHistory = (ChatMultiHistory)chat;
                    ChatTextMessage chatTextMessage = this.buildChatTextMessage(chatMultiHistory.getText(), chatMultiHistory.getRole(), chatMultiHistory.getInlineData());
                    contents.add(chatTextMessage);
                    continue;
                }
                ChatTextMessage textMessage = this.buildChatTextMessage(chat.getText(), chat.getRole());
                contents.add(textMessage);
            }
        }
        ChatTextMessage textMessage = this.buildChatTextMessage(message, "user", inlineData);
        contents.add(textMessage);
        return GeminiTextRequest.builder().contents(contents).build();
    }

    private ChatTextMessage buildChatTextMessage(String text, String role) {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        Object textPart = ((TextPart.TextPartBuilder)TextPart.builder().text(text)).build();
        parts.add((TextPart)textPart);
        return ChatTextMessage.builder().role(role).parts(parts).build();
    }

    private ChatTextMessage buildChatTextMessage(String text, String role, MultiPartInlineData inlineData) {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        Object textPart = ((TextPart.TextPartBuilder)TextPart.builder().text(text)).build();
        parts.add((TextPart)textPart);
        if (inlineData != null) {
            TextPart mediaPart = ((MediaPart.MediaPartBuilder)MediaPart.builder().inlineData(inlineData)).build();
            parts.add(mediaPart);
        }
        return ChatTextMessage.builder().role(role).parts(parts).build();
    }

    private List<ChatHistory> buildChatHistory(String message, MultiPartInlineData inlineData, List<Candidate> candidates, List<ChatHistory> history) {
        if (history == null) {
            history = new ArrayList<ChatHistory>();
        }
        if (inlineData != null) {
            ChatHistory chatMultiHistory = ((ChatMultiHistory.ChatMultiHistoryBuilder)((ChatMultiHistory.ChatMultiHistoryBuilder)((ChatMultiHistory.ChatMultiHistoryBuilder)ChatMultiHistory.builder().text(message)).role("user")).inlineData(inlineData)).build();
            history.add(chatMultiHistory);
        } else {
            Object chatHistory = ((ChatHistory.ChatHistoryBuilder)((ChatHistory.ChatHistoryBuilder)ChatHistory.builder().text(message)).role("user")).build();
            history.add((ChatHistory)chatHistory);
        }
        Content content = candidates.get(0).getContent();
        Object aiChat = ((ChatHistory.ChatHistoryBuilder)((ChatHistory.ChatHistoryBuilder)ChatHistory.builder().text(content.getParts().get(0).getText())).role(content.getRole())).build();
        history.add((ChatHistory)aiChat);
        if (history.size() > 10) {
            history = history.subList(0, 10);
        }
        return history;
    }

    private List<ChatHistory> buildStreamChatHistory(String message, MultiPartInlineData inlineData, StringBuffer aiText, List<ChatHistory> history) {
        if (history == null) {
            history = new ArrayList<ChatHistory>();
        }
        if (inlineData != null) {
            ChatHistory chatMultiHistory = ((ChatMultiHistory.ChatMultiHistoryBuilder)((ChatMultiHistory.ChatMultiHistoryBuilder)((ChatMultiHistory.ChatMultiHistoryBuilder)ChatMultiHistory.builder().text(message)).role("user")).inlineData(inlineData)).build();
            history.add(chatMultiHistory);
        } else {
            Object chatHistory = ((ChatHistory.ChatHistoryBuilder)((ChatHistory.ChatHistoryBuilder)ChatHistory.builder().text(message)).role("user")).build();
            history.add((ChatHistory)chatHistory);
        }
        if (aiText.length() != 0) {
            Object aiChat = ((ChatHistory.ChatHistoryBuilder)((ChatHistory.ChatHistoryBuilder)ChatHistory.builder().text(aiText.toString())).role("model")).build();
            history.add((ChatHistory)aiChat);
        }
        if (history.size() > 10) {
            history = history.subList(0, 10);
        }
        System.out.println("history:" + history);
        return history;
    }

    private OkHttpClient defaultClient() {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)).connectionPool(sharedConnectionPool).readTimeout(30000L, TimeUnit.MILLISECONDS).build();
    }
}

