/*
 * Decompiled with CFR 0.152.
 */
package org.liurb.ai.sdk.openai;

import com.alibaba.fastjson2.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.liurb.ai.sdk.common.bean.ChatHistory;
import org.liurb.ai.sdk.openai.bean.AiMessage;
import org.liurb.ai.sdk.openai.bean.ChatContent;
import org.liurb.ai.sdk.openai.bean.ChatImageContent;
import org.liurb.ai.sdk.openai.bean.ChatMessage;
import org.liurb.ai.sdk.openai.bean.Choice;
import org.liurb.ai.sdk.openai.bean.ImageUrl;
import org.liurb.ai.sdk.openai.bean.MaterialData;
import org.liurb.ai.sdk.openai.bean.OpenAiGenerationConfig;
import org.liurb.ai.sdk.openai.bean.OpenAiMultiChatHistory;
import org.liurb.ai.sdk.openai.bean.StreamChoice;
import org.liurb.ai.sdk.openai.conf.OpenAiAccount;
import org.liurb.ai.sdk.openai.dto.OpenAiStreamResponse;
import org.liurb.ai.sdk.openai.dto.OpenAiTextRequest;
import org.liurb.ai.sdk.openai.dto.OpenAiTextResponse;
import org.liurb.ai.sdk.openai.enums.OpenAiModelEnum;
import org.liurb.ai.sdk.openai.listener.OpenAiStreamResponseListener;

public class OpenAiClient {
    private OpenAiAccount openaiAccount;
    private String BASE_URL = "https://api.openai.com";
    private String MODEL_NAME = OpenAiModelEnum.GPT_35_TURBO.getName();
    private OkHttpClient okHttpClient;
    private static final ConnectionPool sharedConnectionPool = new ConnectionPool(32, 60L, TimeUnit.SECONDS);

    private OpenAiClient() {
    }

    public OpenAiClient(OpenAiAccount openaiAccount) {
        this.openaiAccount = openaiAccount;
        this.okHttpClient = this.defaultClient();
    }

    public OpenAiClient(String modelName, OpenAiAccount openaiAccount) {
        this.openaiAccount = openaiAccount;
        this.okHttpClient = this.defaultClient();
        this.MODEL_NAME = modelName;
    }

    public OpenAiClient(OpenAiAccount openaiAccount, OkHttpClient okHttpClient) {
        this.openaiAccount = openaiAccount;
        this.okHttpClient = okHttpClient;
    }

    public OpenAiClient(String modelName, OpenAiAccount openaiAccount, OkHttpClient okHttpClient) {
        this.openaiAccount = openaiAccount;
        this.okHttpClient = okHttpClient;
        this.MODEL_NAME = modelName;
    }

    public OpenAiTextResponse chat(String message) throws IOException {
        return this.chat(message, null, null, null);
    }

    public OpenAiTextResponse chat(String message, OpenAiGenerationConfig generationConfig) throws IOException {
        return this.chat(message, null, generationConfig, null);
    }

    public OpenAiTextResponse chat(String message, List<ChatHistory> history) throws IOException {
        return this.chat(message, null, null, history);
    }

    public OpenAiTextResponse chat(String message, OpenAiGenerationConfig generationConfig, List<ChatHistory> history) throws IOException {
        return this.chat(message, null, generationConfig, history);
    }

    public OpenAiTextResponse chat(String message, MaterialData materialData) throws IOException {
        return this.chat(message, materialData, null, null);
    }

    public OpenAiTextResponse chat(String message, MaterialData materialData, OpenAiGenerationConfig generationConfig, List<ChatHistory> history) throws IOException {
        if (this.openaiAccount == null || this.openaiAccount.getApiKey() == null || this.openaiAccount.getApiKey().isEmpty()) {
            throw new RuntimeException("gemini api key is empty");
        }
        if (this.openaiAccount.getBaseUrl() != null && !this.openaiAccount.getBaseUrl().isEmpty()) {
            this.BASE_URL = this.openaiAccount.getBaseUrl();
        }
        OpenAiTextRequest questParams = this.buildOpenAiTextRequest(message, materialData, history);
        if (generationConfig != null) {
            questParams.setTemperature(generationConfig.getTemperature());
            questParams.setMaxTokens(generationConfig.getMaxTokens());
            questParams.setTopP(generationConfig.getTopP());
            questParams.setN(generationConfig.getN());
            questParams.setStop(generationConfig.getStop());
        }
        MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)json, (String)JSON.toJSONString((Object)questParams));
        String url = "{base_url}/v1/chat/completions";
        Request request = new Request.Builder().url(url = url.replace("{base_url}", this.BASE_URL)).addHeader("Authorization", "Bearer " + this.openaiAccount.getApiKey()).post(requestBody).build();
        Response response = this.okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            String responseBody = response.body().string();
            System.out.println(responseBody);
            OpenAiTextResponse textResponse = (OpenAiTextResponse)JSON.parseObject((String)responseBody, OpenAiTextResponse.class);
            textResponse.setHistory(this.buildChatHistory(message, materialData, textResponse.getChoices(), history));
            return textResponse;
        }
        return null;
    }

    public void stream(String message, OpenAiStreamResponseListener responseListener) throws IOException {
        this.stream(message, null, null, null, responseListener);
    }

    public void stream(String message, OpenAiGenerationConfig generationConfig, OpenAiStreamResponseListener responseListener) throws IOException {
        this.stream(message, null, generationConfig, null, responseListener);
    }

    public void stream(String message, List<ChatHistory> history, OpenAiStreamResponseListener responseListener) throws IOException {
        this.stream(message, null, null, history, responseListener);
    }

    public void stream(String message, OpenAiGenerationConfig generationConfig, List<ChatHistory> history, OpenAiStreamResponseListener responseListener) throws IOException {
        this.stream(message, null, generationConfig, history, responseListener);
    }

    public void stream(final String message, final MaterialData materialData, OpenAiGenerationConfig generationConfig, final List<ChatHistory> history, final OpenAiStreamResponseListener responseListener) throws IOException {
        if (this.openaiAccount == null || this.openaiAccount.getApiKey() == null || this.openaiAccount.getApiKey().isEmpty()) {
            throw new RuntimeException("gemini api key is empty");
        }
        if (this.openaiAccount.getBaseUrl() != null && !this.openaiAccount.getBaseUrl().isEmpty()) {
            this.BASE_URL = this.openaiAccount.getBaseUrl();
        }
        OpenAiTextRequest questParams = this.buildOpenAiTextRequest(message, materialData, history);
        questParams.setStream(true);
        if (generationConfig != null) {
            questParams.setTemperature(generationConfig.getTemperature());
            questParams.setMaxTokens(generationConfig.getMaxTokens());
            questParams.setTopP(generationConfig.getTopP());
            questParams.setN(generationConfig.getN());
            questParams.setStop(generationConfig.getStop());
        }
        MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)json, (String)JSON.toJSONString((Object)questParams));
        String url = "{base_url}/v1/chat/completions";
        url = url.replace("{base_url}", this.BASE_URL);
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.openaiAccount.getApiKey()).post(requestBody).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    try (ResponseBody responseBody = response.body();){
                        String line;
                        StringBuffer textSb = new StringBuffer();
                        InputStream inputStream = responseBody.byteStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((line = reader.readLine()) != null) {
                            line = line.trim();
                            System.out.println(line);
                            if (!line.startsWith("data: ")) continue;
                            if ("[DONE]".equals(line = line.substring("data: ".length()))) break;
                            OpenAiStreamResponse streamResponse = (OpenAiStreamResponse)JSON.parseObject((String)line, OpenAiStreamResponse.class);
                            StreamChoice streamChoice = streamResponse.getChoices().get(0);
                            AiMessage content = streamChoice.getDelta();
                            textSb.append(content.getContent());
                            responseListener.accept(streamChoice);
                        }
                        OpenAiClient.this.buildStreamChatHistory(message, materialData, textSb, history);
                    }
                }
            }
        });
    }

    private OpenAiTextRequest buildOpenAiTextRequest(String message, MaterialData materialData, List<ChatHistory> history) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        if (history != null && !history.isEmpty()) {
            for (ChatHistory chat : history) {
                if (chat instanceof OpenAiMultiChatHistory) {
                    OpenAiMultiChatHistory openAiMultiChatHistory = (OpenAiMultiChatHistory)chat;
                    ChatMessage chatMessage = this.buildChatMessage(openAiMultiChatHistory.getText(), openAiMultiChatHistory.getRole(), openAiMultiChatHistory.getMaterialData());
                    messages.add(chatMessage);
                    continue;
                }
                ChatMessage chatMessage = this.buildChatMessage(chat.getText(), chat.getRole());
                messages.add(chatMessage);
            }
        }
        ChatMessage chatMessage = this.buildChatMessage(message, "user", materialData);
        messages.add(chatMessage);
        return OpenAiTextRequest.builder().model(this.MODEL_NAME).messages(messages).build();
    }

    private ChatMessage buildChatMessage(String message, String role) {
        return this.buildChatMessage(message, role, null);
    }

    private ChatMessage buildChatMessage(String message, String role, MaterialData materialData) {
        ArrayList<ChatContent> contents = new ArrayList<ChatContent>();
        Object chatContent = ((ChatContent.ChatContentBuilder)((ChatContent.ChatContentBuilder)ChatContent.builder().type("text")).text(message)).build();
        contents.add((ChatContent)chatContent);
        if (materialData != null && "image_url".equals(materialData.getType())) {
            ImageUrl imageUrl = ImageUrl.builder().url(materialData.getUrl()).build();
            ChatContent imageContent = ((ChatImageContent.ChatImageContentBuilder)((ChatImageContent.ChatImageContentBuilder)ChatImageContent.builder().type("image_url")).imageUrl(imageUrl)).build();
            contents.add(imageContent);
        }
        return ChatMessage.builder().role(role).content(contents).build();
    }

    private List<ChatHistory> buildChatHistory(String message, MaterialData materialData, List<Choice> choices, List<ChatHistory> history) {
        Object chatHistory;
        if (history == null) {
            history = new ArrayList<ChatHistory>();
        }
        if (materialData != null) {
            chatHistory = ((OpenAiMultiChatHistory.OpenAiMultiChatHistoryBuilder)((OpenAiMultiChatHistory.OpenAiMultiChatHistoryBuilder)((OpenAiMultiChatHistory.OpenAiMultiChatHistoryBuilder)OpenAiMultiChatHistory.builder().role("user")).text(message)).materialData(materialData)).build();
            history.add((ChatHistory)chatHistory);
        } else {
            chatHistory = ((ChatHistory.ChatHistoryBuilder)((ChatHistory.ChatHistoryBuilder)ChatHistory.builder().role("user")).text(message)).build();
            history.add((ChatHistory)chatHistory);
        }
        AiMessage aiMessage = choices.get(0).getMessage();
        Object aiChat = ((ChatHistory.ChatHistoryBuilder)((ChatHistory.ChatHistoryBuilder)ChatHistory.builder().text(aiMessage.getContent())).role(aiMessage.getRole())).build();
        history.add((ChatHistory)aiChat);
        if (history.size() > 10) {
            history = history.subList(0, 10);
        }
        return history;
    }

    private List<ChatHistory> buildStreamChatHistory(String message, MaterialData materialData, StringBuffer aiText, List<ChatHistory> history) {
        Object chatHistory;
        if (history == null) {
            history = new ArrayList<ChatHistory>();
        }
        if (materialData != null) {
            chatHistory = ((OpenAiMultiChatHistory.OpenAiMultiChatHistoryBuilder)((OpenAiMultiChatHistory.OpenAiMultiChatHistoryBuilder)((OpenAiMultiChatHistory.OpenAiMultiChatHistoryBuilder)OpenAiMultiChatHistory.builder().role("user")).text(message)).materialData(materialData)).build();
            history.add((ChatHistory)chatHistory);
        } else {
            chatHistory = ((ChatHistory.ChatHistoryBuilder)((ChatHistory.ChatHistoryBuilder)ChatHistory.builder().role("user")).text(message)).build();
            history.add((ChatHistory)chatHistory);
        }
        if (aiText.length() != 0) {
            Object aiChat = ((ChatHistory.ChatHistoryBuilder)((ChatHistory.ChatHistoryBuilder)ChatHistory.builder().text(aiText.toString())).role("assistant")).build();
            history.add((ChatHistory)aiChat);
        }
        if (history.size() > 10) {
            history = history.subList(0, 10);
        }
        return history;
    }

    private OkHttpClient defaultClient() {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)).connectionPool(sharedConnectionPool).readTimeout(30000L, TimeUnit.MILLISECONDS).build();
    }
}

