/*
 * Decompiled with CFR 0.152.
 */
package org.liurb.ai.sdk.ollama;

import com.alibaba.fastjson2.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.liurb.ai.sdk.common.AiBaseClient;
import org.liurb.ai.sdk.ollama.bean.OllamaChatHistory;
import org.liurb.ai.sdk.ollama.bean.OllamaChatMessage;
import org.liurb.ai.sdk.ollama.bean.OllamaGenerationConfig;
import org.liurb.ai.sdk.ollama.bean.OllamaMultiChatHistory;
import org.liurb.ai.sdk.ollama.bean.OllamaRequestOptions;
import org.liurb.ai.sdk.ollama.conf.OllamaAccount;
import org.liurb.ai.sdk.ollama.dto.OllamaStreamResponse;
import org.liurb.ai.sdk.ollama.dto.OllamaTextRequest;
import org.liurb.ai.sdk.ollama.dto.OllamaTextResponse;
import org.liurb.ai.sdk.ollama.enums.OllamaModelEnum;
import org.liurb.ai.sdk.ollama.listener.OllamaStreamResponseListener;

public class OllamaClient
extends AiBaseClient {
    private OllamaAccount ollamaAccount;
    private String BASE_URL = "http://localhost:11434";
    private String MODEL_NAME = OllamaModelEnum.LLAMA3_1.getName();
    private OkHttpClient okHttpClient;

    private OllamaClient() {
    }

    public OllamaClient(OllamaAccount ollamaAccount) {
        this.ollamaAccount = ollamaAccount;
        this.okHttpClient = this.getDefaultClient();
    }

    public OllamaClient(String modelName, OllamaAccount ollamaAccount) {
        this.ollamaAccount = ollamaAccount;
        this.okHttpClient = this.getDefaultClient();
        this.MODEL_NAME = modelName;
    }

    public OllamaClient(OllamaAccount ollamaAccount, OkHttpClient okHttpClient) {
        this.ollamaAccount = ollamaAccount;
        this.okHttpClient = okHttpClient;
    }

    public OllamaClient(String modelName, OllamaAccount ollamaAccount, OkHttpClient okHttpClient) {
        this.ollamaAccount = ollamaAccount;
        this.okHttpClient = okHttpClient;
        this.MODEL_NAME = modelName;
    }

    public OllamaTextResponse chat(String message) throws IOException {
        return this.chat(message, null, null, null);
    }

    public OllamaTextResponse chat(String message, OllamaGenerationConfig generationConfig) throws IOException {
        return this.chat(message, null, generationConfig, null);
    }

    public OllamaTextResponse chat(String message, List<OllamaChatHistory> history) throws IOException {
        return this.chat(message, null, null, history);
    }

    public OllamaTextResponse chat(String message, OllamaGenerationConfig generationConfig, List<OllamaChatHistory> history) throws IOException {
        return this.chat(message, null, generationConfig, history);
    }

    public OllamaTextResponse chat(String message, String[] images) throws IOException {
        return this.chat(message, images, null, null);
    }

    public OllamaTextResponse chat(String message, String[] images, OllamaGenerationConfig generationConfig, List<OllamaChatHistory> history) throws IOException {
        if (this.ollamaAccount.getBaseUrl() != null && !this.ollamaAccount.getBaseUrl().isEmpty()) {
            this.BASE_URL = this.ollamaAccount.getBaseUrl();
        }
        OllamaTextRequest questParams = this.buildOllamaTextRequest(message, images, history);
        questParams.setStream(false);
        if (generationConfig != null) {
            OllamaRequestOptions options = OllamaRequestOptions.builder().temperature(generationConfig.getTemperature()).build();
            questParams.setOptions(options);
        }
        MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)json, (String)JSON.toJSONString((Object)questParams));
        String url = "{base_url}/api/chat";
        Request request = new Request.Builder().url(url = url.replace("{base_url}", this.BASE_URL)).addHeader("Authorization", "Bearer " + this.ollamaAccount.getApiKey()).post(requestBody).build();
        Response response = this.okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            String responseBody = response.body().string();
            System.out.println(responseBody);
            OllamaTextResponse textResponse = (OllamaTextResponse)JSON.parseObject((String)responseBody, OllamaTextResponse.class);
            textResponse.setHistory(this.buildChatHistory(message, images, textResponse.getMessage(), history));
            return textResponse;
        }
        return null;
    }

    public void stream(String message, OllamaStreamResponseListener responseListener) throws IOException {
        this.stream(message, null, null, null, responseListener);
    }

    public void stream(String message, OllamaGenerationConfig generationConfig, OllamaStreamResponseListener responseListener) throws IOException {
        this.stream(message, null, generationConfig, null, responseListener);
    }

    public void stream(String message, List<OllamaChatHistory> history, OllamaStreamResponseListener responseListener) throws IOException {
        this.stream(message, null, null, history, responseListener);
    }

    public void stream(String message, OllamaGenerationConfig generationConfig, List<OllamaChatHistory> history, OllamaStreamResponseListener responseListener) throws IOException {
        this.stream(message, null, generationConfig, history, responseListener);
    }

    public void stream(final String message, final String[] images, OllamaGenerationConfig generationConfig, final List<OllamaChatHistory> history, final OllamaStreamResponseListener responseListener) throws IOException {
        if (this.ollamaAccount.getBaseUrl() != null && !this.ollamaAccount.getBaseUrl().isEmpty()) {
            this.BASE_URL = this.ollamaAccount.getBaseUrl();
        }
        OllamaTextRequest questParams = this.buildOllamaTextRequest(message, images, history);
        questParams.setStream(true);
        if (generationConfig != null) {
            OllamaRequestOptions options = OllamaRequestOptions.builder().temperature(generationConfig.getTemperature()).build();
            questParams.setOptions(options);
        }
        MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)json, (String)JSON.toJSONString((Object)questParams));
        String url = "{base_url}/api/chat";
        url = url.replace("{base_url}", this.BASE_URL);
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.ollamaAccount.getApiKey()).post(requestBody).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    try (ResponseBody responseBody = response.body();){
                        OllamaStreamResponse streamResponse;
                        Boolean done;
                        String line;
                        StringBuffer textSb = new StringBuffer();
                        InputStream inputStream = responseBody.byteStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((line = reader.readLine()) != null && !(done = (streamResponse = (OllamaStreamResponse)JSON.parseObject((String)(line = line.trim()), OllamaStreamResponse.class)).getDone()).booleanValue()) {
                            OllamaChatMessage streamMessage = streamResponse.getMessage();
                            textSb.append(streamMessage.getContent());
                            responseListener.accept(streamMessage);
                        }
                        OllamaClient.this.buildStreamChatHistory(message, images, textSb, history);
                    }
                }
            }
        });
    }

    private OllamaTextRequest buildOllamaTextRequest(String message, String[] images, List<OllamaChatHistory> history) {
        ArrayList<OllamaChatMessage> messages = new ArrayList<OllamaChatMessage>();
        if (history != null && !history.isEmpty()) {
            for (OllamaChatHistory chat : history) {
                if (chat instanceof OllamaMultiChatHistory) {
                    OllamaMultiChatHistory multiChatHistory = (OllamaMultiChatHistory)chat;
                    OllamaChatMessage chatMessage = this.buildChatMessage(multiChatHistory.getContent(), multiChatHistory.getRole(), multiChatHistory.getImages());
                    messages.add(chatMessage);
                    continue;
                }
                OllamaChatMessage chatMessage = this.buildChatMessage(chat.getContent(), chat.getRole());
                messages.add(chatMessage);
            }
        }
        OllamaChatMessage chatMessage = this.buildChatMessage(message, "user", images);
        messages.add(chatMessage);
        return OllamaTextRequest.builder().model(this.MODEL_NAME).messages(messages).build();
    }

    private OllamaChatMessage buildChatMessage(String message, String role) {
        return this.buildChatMessage(message, role, null);
    }

    private OllamaChatMessage buildChatMessage(String message, String role, String[] images) {
        OllamaChatMessage chatMessage = OllamaChatMessage.builder().role(role).content(message).build();
        if (images != null && images.length > 0) {
            chatMessage.setImages(images);
        }
        return chatMessage;
    }

    private List<OllamaChatHistory> buildChatHistory(String message, String[] images, OllamaChatMessage responseMessage, List<OllamaChatHistory> history) {
        Object aiChat;
        Object chatHistory;
        if (history == null) {
            history = new ArrayList<OllamaChatHistory>();
        }
        if (images != null) {
            chatHistory = ((OllamaMultiChatHistory.OllamaMultiChatHistoryBuilder)((OllamaMultiChatHistory.OllamaMultiChatHistoryBuilder)((OllamaMultiChatHistory.OllamaMultiChatHistoryBuilder)OllamaMultiChatHistory.builder().role("user")).content(message)).images(images)).build();
            history.add((OllamaChatHistory)chatHistory);
        } else {
            chatHistory = ((OllamaChatHistory.OllamaChatHistoryBuilder)((OllamaChatHistory.OllamaChatHistoryBuilder)OllamaChatHistory.builder().role("user")).content(message)).build();
            history.add((OllamaChatHistory)chatHistory);
        }
        if (responseMessage.getImages() != null && responseMessage.getImages().length > 0) {
            aiChat = ((OllamaMultiChatHistory.OllamaMultiChatHistoryBuilder)((OllamaMultiChatHistory.OllamaMultiChatHistoryBuilder)((OllamaMultiChatHistory.OllamaMultiChatHistoryBuilder)OllamaMultiChatHistory.builder().content(responseMessage.getContent())).role(responseMessage.getRole())).images(responseMessage.getImages())).build();
            history.add((OllamaChatHistory)aiChat);
        } else {
            aiChat = ((OllamaChatHistory.OllamaChatHistoryBuilder)((OllamaChatHistory.OllamaChatHistoryBuilder)OllamaChatHistory.builder().content(responseMessage.getContent())).role(responseMessage.getRole())).build();
            history.add((OllamaChatHistory)aiChat);
        }
        if (history.size() > 10) {
            history = history.subList(0, 10);
        }
        return history;
    }

    private void buildStreamChatHistory(String message, String[] images, StringBuffer aiText, List<OllamaChatHistory> history) {
        Object chatHistory;
        if (history == null) {
            history = new ArrayList<OllamaChatHistory>();
        }
        if (images != null) {
            chatHistory = ((OllamaMultiChatHistory.OllamaMultiChatHistoryBuilder)((OllamaMultiChatHistory.OllamaMultiChatHistoryBuilder)((OllamaMultiChatHistory.OllamaMultiChatHistoryBuilder)OllamaMultiChatHistory.builder().role("user")).content(message)).images(images)).build();
            history.add((OllamaChatHistory)chatHistory);
        } else {
            chatHistory = ((OllamaChatHistory.OllamaChatHistoryBuilder)((OllamaChatHistory.OllamaChatHistoryBuilder)OllamaChatHistory.builder().role("user")).content(message)).build();
            history.add((OllamaChatHistory)chatHistory);
        }
        if (aiText.length() != 0) {
            Object aiChat = ((OllamaChatHistory.OllamaChatHistoryBuilder)((OllamaChatHistory.OllamaChatHistoryBuilder)OllamaChatHistory.builder().content(aiText.toString())).role("assistant")).build();
            history.add((OllamaChatHistory)aiChat);
        }
        if (history.size() > 10) {
            history = history.subList(0, 10);
        }
    }
}

