/*
 * Decompiled with CFR 0.152.
 */
package org.liurb.ai.sdk.openai.dto;

import com.alibaba.fastjson2.annotation.JSONField;
import java.util.List;
import org.liurb.ai.sdk.openai.bean.ChatMessage;

public class OpenAiTextRequest {
    @JSONField(name="model")
    private String model;
    @JSONField(name="messages")
    private List<ChatMessage> messages;
    @JSONField(name="max_tokens")
    private Integer maxTokens;
    private Integer n;
    private String stop;
    private boolean stream;
    private Double temperature;
    @JSONField(name="top_p")
    private Double topP;

    OpenAiTextRequest(String model, List<ChatMessage> messages, Integer maxTokens, Integer n, String stop, boolean stream, Double temperature, Double topP) {
        this.model = model;
        this.messages = messages;
        this.maxTokens = maxTokens;
        this.n = n;
        this.stop = stop;
        this.stream = stream;
        this.temperature = temperature;
        this.topP = topP;
    }

    public static OpenAiTextRequestBuilder builder() {
        return new OpenAiTextRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public String getStop() {
        return this.stop;
    }

    public boolean isStream() {
        return this.stream;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMessages(List<ChatMessage> messages) {
        this.messages = messages;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStop(String stop) {
        this.stop = stop;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenAiTextRequest)) {
            return false;
        }
        OpenAiTextRequest other = (OpenAiTextRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ChatMessage> this$messages = this.getMessages();
        List<ChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$stop = this.getStop();
        String other$stop = other.getStop();
        return !(this$stop == null ? other$stop != null : !this$stop.equals(other$stop));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenAiTextRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStream() ? 79 : 97);
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : $stop.hashCode());
        return result;
    }

    public String toString() {
        return "OpenAiTextRequest(model=" + this.getModel() + ", messages=" + this.getMessages() + ", maxTokens=" + this.getMaxTokens() + ", n=" + this.getN() + ", stop=" + this.getStop() + ", stream=" + this.isStream() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ")";
    }

    public static class OpenAiTextRequestBuilder {
        private String model;
        private List<ChatMessage> messages;
        private Integer maxTokens;
        private Integer n;
        private String stop;
        private boolean stream;
        private Double temperature;
        private Double topP;

        OpenAiTextRequestBuilder() {
        }

        public OpenAiTextRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public OpenAiTextRequestBuilder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public OpenAiTextRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public OpenAiTextRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public OpenAiTextRequestBuilder stop(String stop) {
            this.stop = stop;
            return this;
        }

        public OpenAiTextRequestBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public OpenAiTextRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OpenAiTextRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public OpenAiTextRequest build() {
            return new OpenAiTextRequest(this.model, this.messages, this.maxTokens, this.n, this.stop, this.stream, this.temperature, this.topP);
        }

        public String toString() {
            return "OpenAiTextRequest.OpenAiTextRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", maxTokens=" + this.maxTokens + ", n=" + this.n + ", stop=" + this.stop + ", stream=" + this.stream + ", temperature=" + this.temperature + ", topP=" + this.topP + ")";
        }
    }
}

