/*
 * Decompiled with CFR 0.152.
 */
package org.liurb.ai.sdk.openai;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.liurb.ai.sdk.common.AiBaseClient;
import org.liurb.ai.sdk.common.bean.AiStreamMessage;
import org.liurb.ai.sdk.common.bean.ChatHistory;
import org.liurb.ai.sdk.common.bean.ChatMessage;
import org.liurb.ai.sdk.common.bean.GenerationConfig;
import org.liurb.ai.sdk.common.bean.MediaData;
import org.liurb.ai.sdk.common.bean.ModelAccount;
import org.liurb.ai.sdk.common.dto.AiChatResponse;
import org.liurb.ai.sdk.openai.bean.ChatContent;
import org.liurb.ai.sdk.openai.bean.ChatImageContent;
import org.liurb.ai.sdk.openai.bean.ImageUrl;
import org.liurb.ai.sdk.openai.bean.OpenAiChatHistory;
import org.liurb.ai.sdk.openai.bean.OpenAiChatMessage;
import org.liurb.ai.sdk.openai.bean.OpenAiMessage;
import org.liurb.ai.sdk.openai.bean.StreamChoice;
import org.liurb.ai.sdk.openai.dto.OpenAiStreamResponse;
import org.liurb.ai.sdk.openai.dto.OpenAiTextRequest;
import org.liurb.ai.sdk.openai.dto.OpenAiTextResponse;
import org.liurb.ai.sdk.openai.enums.OpenAiModelEnum;

public class OpenAiClient
extends AiBaseClient {
    public OpenAiClient(ModelAccount account) {
        super(account);
    }

    public OpenAiClient(String modelName, ModelAccount account) {
        super(modelName, account);
    }

    private OpenAiTextRequest buildOpenAiTextRequest(String message, MediaData mediaData, List<ChatHistory> history) {
        ArrayList<OpenAiChatMessage> messages = new ArrayList<OpenAiChatMessage>();
        if (history != null && !history.isEmpty()) {
            for (ChatHistory chat : history) {
                if (chat instanceof OpenAiChatHistory) {
                    OpenAiChatHistory openAiChatHistory = (OpenAiChatHistory)chat;
                    OpenAiChatMessage chatMessage = this.buildChatMessage(openAiChatHistory.getContent(), openAiChatHistory.getRole(), openAiChatHistory.getMediaData());
                    messages.add(chatMessage);
                    continue;
                }
                OpenAiChatMessage chatMessage = this.buildChatMessage(chat.getContent(), chat.getRole());
                messages.add(chatMessage);
            }
        }
        OpenAiChatMessage chatMessage = this.buildChatMessage(message, "user", mediaData);
        messages.add(chatMessage);
        return OpenAiTextRequest.builder().model(this.getModelName()).messages(messages).build();
    }

    private OpenAiChatMessage buildChatMessage(String message, String role) {
        return this.buildChatMessage(message, role, null);
    }

    private OpenAiChatMessage buildChatMessage(String message, String role, MediaData mediaData) {
        ArrayList<ChatContent> contents = new ArrayList<ChatContent>();
        Object chatContent = ((ChatContent.ChatContentBuilder)((ChatContent.ChatContentBuilder)ChatContent.builder().type("text")).text(message)).build();
        contents.add((ChatContent)chatContent);
        if (mediaData != null && "image_url".equals(mediaData.getType())) {
            ImageUrl imageUrl = ImageUrl.builder().url(mediaData.getUrl()).build();
            ChatContent imageContent = ((ChatImageContent.ChatImageContentBuilder)((ChatImageContent.ChatImageContentBuilder)ChatImageContent.builder().type("image_url")).imageUrl(imageUrl)).build();
            contents.add(imageContent);
        }
        return OpenAiChatMessage.builder().role(role).content(contents).build();
    }

    private List<ChatHistory> buildChatHistory(String message, MediaData mediaData, ChatMessage aiChatMessage, List<ChatHistory> history) {
        Object chatHistory;
        if (history == null) {
            history = new ArrayList<ChatHistory>();
        }
        if (mediaData != null) {
            chatHistory = ((OpenAiChatHistory.OpenAiChatHistoryBuilder)((OpenAiChatHistory.OpenAiChatHistoryBuilder)((OpenAiChatHistory.OpenAiChatHistoryBuilder)OpenAiChatHistory.builder().role("user")).content(message)).mediaData(mediaData)).build();
            history.add((ChatHistory)chatHistory);
        } else {
            chatHistory = ((ChatHistory.ChatHistoryBuilder)((ChatHistory.ChatHistoryBuilder)ChatHistory.builder().role("user")).content(message)).build();
            history.add((ChatHistory)chatHistory);
        }
        Object aiChat = ((ChatHistory.ChatHistoryBuilder)((ChatHistory.ChatHistoryBuilder)ChatHistory.builder().content(aiChatMessage.getContent())).role(aiChatMessage.getRole())).build();
        history.add((ChatHistory)aiChat);
        if (history.size() > 10) {
            history = history.subList(0, 10);
        }
        return history;
    }

    @Override
    protected String getDefaultModelName() {
        return OpenAiModelEnum.GPT_35_TURBO.getName();
    }

    @Override
    protected String getDefaultBaseUrl() {
        return "https://api.openai.com";
    }

    @Override
    protected String getApi() {
        return "/v1/chat/completions";
    }

    @Override
    protected JSONObject buildChatRequest(String message, MediaData mediaData, GenerationConfig generationConfig, boolean stream, List<ChatHistory> history) {
        OpenAiTextRequest questParams = this.buildOpenAiTextRequest(message, mediaData, history);
        questParams.setStream(stream);
        if (generationConfig != null) {
            questParams.setTemperature(generationConfig.getTemperature());
            questParams.setMaxTokens(generationConfig.getMaxTokens());
            questParams.setTopP(generationConfig.getTopP());
            questParams.setStop(generationConfig.getStop());
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)questParams));
    }

    @Override
    protected AiChatResponse buildChatResponse(String responseBody, String message, MediaData mediaData, List<ChatHistory> history) {
        AiChatResponse response = new AiChatResponse();
        OpenAiTextResponse openAiTextResponse = (OpenAiTextResponse)JSON.parseObject((String)responseBody, OpenAiTextResponse.class);
        OpenAiMessage aiMessage = openAiTextResponse.getChoices().get(0).getMessage();
        Object resMessage = ((ChatMessage.ChatMessageBuilder)((ChatMessage.ChatMessageBuilder)ChatMessage.builder().content(aiMessage.getContent())).role(aiMessage.getRole())).build();
        response.setMessage((ChatMessage)resMessage);
        List<ChatHistory> newHistory = this.buildChatHistory(message, mediaData, (ChatMessage)resMessage, history);
        response.setHistory(newHistory);
        return response;
    }

    @Override
    protected AiStreamMessage buildStreamMessage(String responseLine) {
        if (responseLine.startsWith("data: ")) {
            if ("[DONE]".equals(responseLine = responseLine.substring("data: ".length()))) {
                return ((AiStreamMessage.AiStreamMessageBuilder)AiStreamMessage.builder().stop(true)).build();
            }
            OpenAiStreamResponse streamResponse = (OpenAiStreamResponse)JSON.parseObject((String)responseLine, OpenAiStreamResponse.class);
            StreamChoice streamChoice = streamResponse.getChoices().get(0);
            OpenAiMessage content = streamChoice.getDelta();
            return ((AiStreamMessage.AiStreamMessageBuilder)((AiStreamMessage.AiStreamMessageBuilder)((AiStreamMessage.AiStreamMessageBuilder)AiStreamMessage.builder().stop(false)).content(content.getContent())).role(content.getRole())).build();
        }
        return null;
    }

    @Override
    protected void buildStreamChatHistory(String message, MediaData mediaData, String aiMessage, List<ChatHistory> history) {
        Object resMessage = ((ChatMessage.ChatMessageBuilder)((ChatMessage.ChatMessageBuilder)ChatMessage.builder().role("assistant")).content(aiMessage)).build();
        this.buildChatHistory(message, mediaData, (ChatMessage)resMessage, history);
    }
}

