/*
 * Decompiled with CFR 0.152.
 */
package org.liurb.ai.sdk.openai.bean;

import java.util.List;
import org.liurb.ai.sdk.openai.bean.ChatContent;

public class OpenAiChatMessage {
    private String role;
    private List<ChatContent> content;

    OpenAiChatMessage(String role, List<ChatContent> content) {
        this.role = role;
        this.content = content;
    }

    public static OpenAiChatMessageBuilder builder() {
        return new OpenAiChatMessageBuilder();
    }

    public String getRole() {
        return this.role;
    }

    public List<ChatContent> getContent() {
        return this.content;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(List<ChatContent> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenAiChatMessage)) {
            return false;
        }
        OpenAiChatMessage other = (OpenAiChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        List<ChatContent> this$content = this.getContent();
        List<ChatContent> other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenAiChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        List<ChatContent> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public String toString() {
        return "OpenAiChatMessage(role=" + this.getRole() + ", content=" + this.getContent() + ")";
    }

    public static class OpenAiChatMessageBuilder {
        private String role;
        private List<ChatContent> content;

        OpenAiChatMessageBuilder() {
        }

        public OpenAiChatMessageBuilder role(String role) {
            this.role = role;
            return this;
        }

        public OpenAiChatMessageBuilder content(List<ChatContent> content) {
            this.content = content;
            return this;
        }

        public OpenAiChatMessage build() {
            return new OpenAiChatMessage(this.role, this.content);
        }

        public String toString() {
            return "OpenAiChatMessage.OpenAiChatMessageBuilder(role=" + this.role + ", content=" + this.content + ")";
        }
    }
}

