/*
 * Decompiled with CFR 0.152.
 */
package org.liurb.ai.sdk.common.bean;

public class ChatMessage {
    String role;
    String content;

    protected ChatMessage(ChatMessageBuilder<?, ?> b) {
        this.role = ((ChatMessageBuilder)b).role;
        this.content = ((ChatMessageBuilder)b).content;
    }

    public static ChatMessageBuilder<?, ?> builder() {
        return new ChatMessageBuilderImpl();
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    private static final class ChatMessageBuilderImpl
    extends ChatMessageBuilder<ChatMessage, ChatMessageBuilderImpl> {
        private ChatMessageBuilderImpl() {
        }

        @Override
        protected ChatMessageBuilderImpl self() {
            return this;
        }

        @Override
        public ChatMessage build() {
            return new ChatMessage(this);
        }
    }

    public static abstract class ChatMessageBuilder<C extends ChatMessage, B extends ChatMessageBuilder<C, B>> {
        private String role;
        private String content;

        public B role(String role) {
            this.role = role;
            return this.self();
        }

        public B content(String content) {
            this.content = content;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ChatMessage.ChatMessageBuilder(role=" + this.role + ", content=" + this.content + ")";
        }
    }
}

