/*
 * Decompiled with CFR 0.152.
 */
package org.liurb.ai.sdk.common;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.liurb.ai.sdk.common.bean.AiStreamMessage;
import org.liurb.ai.sdk.common.bean.ChatHistory;
import org.liurb.ai.sdk.common.bean.GenerationConfig;
import org.liurb.ai.sdk.common.bean.MediaData;
import org.liurb.ai.sdk.common.bean.ModelAccount;
import org.liurb.ai.sdk.common.dto.AiChatResponse;
import org.liurb.ai.sdk.common.listener.AiStreamResponseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AiBaseClient {
    private static final Logger log = LoggerFactory.getLogger(AiBaseClient.class);
    private ModelAccount account;
    private OkHttpClient okHttpClient;
    private boolean stream;
    private static final ConnectionPool sharedConnectionPool = new ConnectionPool(32, 60L, TimeUnit.SECONDS);

    private AiBaseClient() {
    }

    public AiBaseClient(ModelAccount account) {
        this.account = account;
        this.okHttpClient = this.getDefaultClient();
    }

    public AiBaseClient(ModelAccount account, OkHttpClient okHttpClient) {
        this.account = account;
        this.okHttpClient = okHttpClient;
    }

    public AiChatResponse chat(String message) throws IOException {
        return this.chat(this.getDefaultModelName(), message);
    }

    public AiChatResponse chat(String modelName, String message) throws IOException {
        return this.chat(modelName, message, null);
    }

    public AiChatResponse chat(String message, GenerationConfig generationConfig) throws IOException {
        return this.chat(this.getDefaultModelName(), message, generationConfig);
    }

    public AiChatResponse chat(String modelName, String message, GenerationConfig generationConfig) throws IOException {
        return this.chat(modelName, message, generationConfig, null);
    }

    public AiChatResponse chat(String message, GenerationConfig generationConfig, List<ChatHistory> history) throws IOException {
        return this.chat(this.getDefaultModelName(), message, null, generationConfig, history);
    }

    public AiChatResponse chat(String modelName, String message, GenerationConfig generationConfig, List<ChatHistory> history) throws IOException {
        return this.chat(modelName, message, null, generationConfig, history);
    }

    public AiChatResponse chat(String message, MediaData mediaData, GenerationConfig generationConfig, List<ChatHistory> history) throws IOException {
        return this.chat(this.getDefaultModelName(), message, mediaData, generationConfig, history);
    }

    public AiChatResponse chat(String modelName, String message, MediaData mediaData, GenerationConfig generationConfig, List<ChatHistory> history) throws IOException {
        this.stream = false;
        Request request = this.buildHttpRequest(modelName, message, mediaData, generationConfig, false, history);
        Response response = this.okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            String responseBody = response.body().string();
            return this.buildChatResponse(responseBody, message, mediaData, history);
        }
        return null;
    }

    public void stream(String message, AiStreamResponseListener responseListener) throws IOException {
        this.stream(this.getDefaultModelName(), message, responseListener);
    }

    public void stream(String modelName, String message, AiStreamResponseListener responseListener) throws IOException {
        this.stream(modelName, message, null, null, responseListener);
    }

    public void stream(String message, GenerationConfig generationConfig, AiStreamResponseListener responseListener) throws IOException {
        this.stream(this.getDefaultModelName(), message, null, generationConfig, null, responseListener);
    }

    public void stream(String modelName, String message, GenerationConfig generationConfig, AiStreamResponseListener responseListener) throws IOException {
        this.stream(modelName, message, null, generationConfig, null, responseListener);
    }

    public void stream(String message, GenerationConfig generationConfig, List<ChatHistory> history, AiStreamResponseListener responseListener) throws IOException {
        this.stream(this.getDefaultModelName(), message, null, generationConfig, history, responseListener);
    }

    public void stream(String modelName, String message, GenerationConfig generationConfig, List<ChatHistory> history, AiStreamResponseListener responseListener) throws IOException {
        this.stream(modelName, message, null, generationConfig, history, responseListener);
    }

    public void stream(String message, MediaData mediaData, GenerationConfig generationConfig, List<ChatHistory> history, AiStreamResponseListener responseListener) throws IOException {
        this.stream(this.getDefaultModelName(), message, mediaData, generationConfig, history, responseListener);
    }

    public void stream(String modelName, final String message, final MediaData mediaData, GenerationConfig generationConfig, final List<ChatHistory> history, final AiStreamResponseListener responseListener) throws IOException {
        this.stream = true;
        Request request = this.buildHttpRequest(modelName, message, mediaData, generationConfig, true, history);
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    try (ResponseBody responseBody = response.body();){
                        String line;
                        StringBuffer textSb = new StringBuffer();
                        InputStream inputStream = responseBody.byteStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((line = reader.readLine()) != null) {
                            line = line.trim();
                            log.debug(line);
                            AiStreamMessage streamMessage = AiBaseClient.this.buildStreamMessage(line);
                            if (streamMessage == null) continue;
                            if (streamMessage.isStop()) break;
                            textSb.append(streamMessage.getContent());
                            responseListener.accept(streamMessage);
                        }
                        AiBaseClient.this.buildStreamChatHistory(message, mediaData, textSb.toString(), history);
                    }
                    finally {
                        responseListener.accept((AiStreamMessage)((AiStreamMessage.AiStreamMessageBuilder)AiStreamMessage.builder().stop(true)).build());
                    }
                }
            }
        });
    }

    private Request buildHttpRequest(String modelName, String message, MediaData mediaData, GenerationConfig generationConfig, boolean stream, List<ChatHistory> history) {
        String baseUrl = this.getDefaultBaseUrl();
        if (this.getAccount() != null && this.getAccount().getBaseUrl() != null && !this.getAccount().getBaseUrl().isEmpty()) {
            baseUrl = this.getAccount().getBaseUrl();
        }
        JSONObject chatRequestParams = this.buildChatRequest(modelName, message, mediaData, generationConfig, stream, history);
        MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)json, (String)JSON.toJSONString((Object)chatRequestParams));
        String url = baseUrl + this.getApi(modelName);
        return new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.getAccount().getApiKey()).post(requestBody).build();
    }

    private OkHttpClient defaultClient() {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)).connectionPool(sharedConnectionPool).readTimeout(60000L, TimeUnit.MILLISECONDS).build();
    }

    protected OkHttpClient getDefaultClient() {
        return this.defaultClient();
    }

    protected ModelAccount getAccount() {
        return this.account;
    }

    protected boolean getStreaming() {
        return this.stream;
    }

    protected abstract String getDefaultModelName();

    protected abstract String getDefaultBaseUrl();

    protected abstract String getApi(String var1);

    protected abstract JSONObject buildChatRequest(String var1, String var2, MediaData var3, GenerationConfig var4, boolean var5, List<ChatHistory> var6);

    protected abstract AiChatResponse buildChatResponse(String var1, String var2, MediaData var3, List<ChatHistory> var4);

    protected abstract AiStreamMessage buildStreamMessage(String var1);

    protected abstract void buildStreamChatHistory(String var1, MediaData var2, String var3, List<ChatHistory> var4);
}

