/*
 * Decompiled with CFR 0.152.
 */
package org.liurb.ai.sdk.gemini.dto;

import java.util.List;
import org.liurb.ai.sdk.gemini.bean.GeminiChatMessage;
import org.liurb.ai.sdk.gemini.bean.GeminiGenerationConfig;
import org.liurb.ai.sdk.gemini.bean.SafetySetting;

public class GeminiTextRequest {
    private List<GeminiChatMessage> contents;
    private GeminiGenerationConfig generationConfig;
    private List<SafetySetting> safetySettings;

    GeminiTextRequest(List<GeminiChatMessage> contents, GeminiGenerationConfig generationConfig, List<SafetySetting> safetySettings) {
        this.contents = contents;
        this.generationConfig = generationConfig;
        this.safetySettings = safetySettings;
    }

    public static GeminiTextRequestBuilder builder() {
        return new GeminiTextRequestBuilder();
    }

    public List<GeminiChatMessage> getContents() {
        return this.contents;
    }

    public GeminiGenerationConfig getGenerationConfig() {
        return this.generationConfig;
    }

    public List<SafetySetting> getSafetySettings() {
        return this.safetySettings;
    }

    public void setContents(List<GeminiChatMessage> contents) {
        this.contents = contents;
    }

    public void setGenerationConfig(GeminiGenerationConfig generationConfig) {
        this.generationConfig = generationConfig;
    }

    public void setSafetySettings(List<SafetySetting> safetySettings) {
        this.safetySettings = safetySettings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeminiTextRequest)) {
            return false;
        }
        GeminiTextRequest other = (GeminiTextRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<GeminiChatMessage> this$contents = this.getContents();
        List<GeminiChatMessage> other$contents = other.getContents();
        if (this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents)) {
            return false;
        }
        GeminiGenerationConfig this$generationConfig = this.getGenerationConfig();
        GeminiGenerationConfig other$generationConfig = other.getGenerationConfig();
        if (this$generationConfig == null ? other$generationConfig != null : !((Object)this$generationConfig).equals(other$generationConfig)) {
            return false;
        }
        List<SafetySetting> this$safetySettings = this.getSafetySettings();
        List<SafetySetting> other$safetySettings = other.getSafetySettings();
        return !(this$safetySettings == null ? other$safetySettings != null : !((Object)this$safetySettings).equals(other$safetySettings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeminiTextRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<GeminiChatMessage> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        GeminiGenerationConfig $generationConfig = this.getGenerationConfig();
        result = result * 59 + ($generationConfig == null ? 43 : ((Object)$generationConfig).hashCode());
        List<SafetySetting> $safetySettings = this.getSafetySettings();
        result = result * 59 + ($safetySettings == null ? 43 : ((Object)$safetySettings).hashCode());
        return result;
    }

    public String toString() {
        return "GeminiTextRequest(contents=" + this.getContents() + ", generationConfig=" + this.getGenerationConfig() + ", safetySettings=" + this.getSafetySettings() + ")";
    }

    public static class GeminiTextRequestBuilder {
        private List<GeminiChatMessage> contents;
        private GeminiGenerationConfig generationConfig;
        private List<SafetySetting> safetySettings;

        GeminiTextRequestBuilder() {
        }

        public GeminiTextRequestBuilder contents(List<GeminiChatMessage> contents) {
            this.contents = contents;
            return this;
        }

        public GeminiTextRequestBuilder generationConfig(GeminiGenerationConfig generationConfig) {
            this.generationConfig = generationConfig;
            return this;
        }

        public GeminiTextRequestBuilder safetySettings(List<SafetySetting> safetySettings) {
            this.safetySettings = safetySettings;
            return this;
        }

        public GeminiTextRequest build() {
            return new GeminiTextRequest(this.contents, this.generationConfig, this.safetySettings);
        }

        public String toString() {
            return "GeminiTextRequest.GeminiTextRequestBuilder(contents=" + this.contents + ", generationConfig=" + this.generationConfig + ", safetySettings=" + this.safetySettings + ")";
        }
    }
}

