/*
 * Decompiled with CFR 0.152.
 */
package org.liurb.ai.sdk.ollama.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.liurb.ai.sdk.common.bean.ChatMessage;

public class OllamaChatMessage
extends ChatMessage {
    List<String> images;

    protected OllamaChatMessage(OllamaChatMessageBuilder<?, ?> b) {
        super(b);
        List<Object> images;
        switch (((OllamaChatMessageBuilder)b).images == null ? 0 : ((OllamaChatMessageBuilder)b).images.size()) {
            case 0: {
                images = Collections.emptyList();
                break;
            }
            case 1: {
                images = Collections.singletonList((String)((OllamaChatMessageBuilder)b).images.get(0));
                break;
            }
            default: {
                images = Collections.unmodifiableList(new ArrayList(((OllamaChatMessageBuilder)b).images));
            }
        }
        this.images = images;
    }

    public static OllamaChatMessageBuilder<?, ?> builder() {
        return new OllamaChatMessageBuilderImpl();
    }

    public List<String> getImages() {
        return this.images;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }

    public static abstract class OllamaChatMessageBuilder<C extends OllamaChatMessage, B extends OllamaChatMessageBuilder<C, B>>
    extends ChatMessage.ChatMessageBuilder<C, B> {
        private ArrayList<String> images;

        public B image(String image) {
            if (this.images == null) {
                this.images = new ArrayList();
            }
            this.images.add(image);
            return (B)this.self();
        }

        public B images(Collection<? extends String> images) {
            if (images == null) {
                throw new NullPointerException("images cannot be null");
            }
            if (this.images == null) {
                this.images = new ArrayList();
            }
            this.images.addAll(images);
            return (B)this.self();
        }

        public B clearImages() {
            if (this.images != null) {
                this.images.clear();
            }
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "OllamaChatMessage.OllamaChatMessageBuilder(super=" + super.toString() + ", images=" + this.images + ")";
        }
    }

    private static final class OllamaChatMessageBuilderImpl
    extends OllamaChatMessageBuilder<OllamaChatMessage, OllamaChatMessageBuilderImpl> {
        private OllamaChatMessageBuilderImpl() {
        }

        @Override
        protected OllamaChatMessageBuilderImpl self() {
            return this;
        }

        @Override
        public OllamaChatMessage build() {
            return new OllamaChatMessage(this);
        }
    }
}

