/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.liveontologies.protege.explanation.proof.ImportsClosureRecord;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class ImportsClosureManager
implements OWLOntologyChangeListener,
Disposable {
    private static final String KEY_ = "org.liveontologies.protege.explanation.proof.imports";
    private final OWLOntologyManager ontologyManager_;
    private final Map<OWLOntology, ImportsClosureRecord> ontologyClosureManagers_ = new HashMap<OWLOntology, ImportsClosureRecord>();

    private ImportsClosureManager(OWLOntologyManager ontologyManager) {
        this.ontologyManager_ = ontologyManager;
        ontologyManager.addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public static synchronized ImportsClosureManager get(OWLEditorKit editorKit) throws Exception {
        ImportsClosureManager m = (ImportsClosureManager)editorKit.getModelManager().get((Object)KEY_);
        if (m == null) {
            m = new ImportsClosureManager(editorKit.getModelManager().getOWLOntologyManager());
            editorKit.put((Object)KEY_, (Disposable)m);
        }
        return m;
    }

    synchronized ImportsClosureRecord getImportsClosure(OWLOntology ontology) {
        ImportsClosureRecord result = this.ontologyClosureManagers_.get(ontology);
        if (result == null) {
            result = new ImportsClosureRecord(ontology);
            this.ontologyClosureManagers_.put(ontology, result);
        }
        return result;
    }

    public void dispose() {
        this.ontologyManager_.removeOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        for (ImportsClosureRecord record : this.ontologyClosureManagers_.values()) {
            if (!record.isUpToDate()) continue;
            for (OWLOntologyChange oWLOntologyChange : changes) {
                OWLOntology changedOntology = oWLOntologyChange.getOntology();
                if (!record.getImportsClosure().contains(changedOntology)) continue;
                record.invalidateLater();
                return;
            }
        }
    }
}

