/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportsClosureRecord {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ImportsClosureRecord.class);
    private final OWLOntology rootOntology_;
    private Set<OWLOntology> importsClosure_;
    private final ListMultimap<OWLAxiom, OWLAxiom> originalAxioms_ = ArrayListMultimap.create();
    private final ListMultimap<OWLAxiom, OWLOntology> axiomOccurrences_ = ArrayListMultimap.create();
    private final List<ChangeListener> listeners_ = new ArrayList<ChangeListener>(2);
    private boolean axiomsUpToDate_ = false;

    public ImportsClosureRecord(OWLOntology rootOntology) {
        this.rootOntology_ = rootOntology;
    }

    public OWLOntology getRootOntology() {
        return this.rootOntology_;
    }

    public synchronized List<OWLOntology> getHomeOntologies(OWLAxiom axiom) {
        this.updateIfNeeded();
        return this.axiomOccurrences_.get((Object)axiom.getAxiomWithoutAnnotations());
    }

    public synchronized List<OWLAxiom> getMatchingAxioms(OWLAxiom axiom) {
        this.updateIfNeeded();
        return this.originalAxioms_.get((Object)axiom.getAxiomWithoutAnnotations());
    }

    public synchronized Set<OWLAxiom> getStatedAxiomsWithoutAnnotations() {
        this.updateIfNeeded();
        return this.axiomOccurrences_.keySet();
    }

    synchronized Set<? extends OWLOntology> getImportsClosure() {
        return this.importsClosure_;
    }

    boolean isUpToDate() {
        return this.axiomsUpToDate_;
    }

    public synchronized void addListener(ChangeListener listener) {
        this.listeners_.add(listener);
    }

    public synchronized void removeListener(ChangeListener listener) {
        this.listeners_.remove(listener);
    }

    synchronized boolean updateIfNeeded() {
        if (this.axiomsUpToDate_) {
            return false;
        }
        this.importsClosure_ = this.rootOntology_.getImportsClosure();
        for (OWLOntology ontology : this.importsClosure_) {
            for (OWLAxiom axiom : ontology.getAxioms()) {
                OWLAxiom key = axiom.getAxiomWithoutAnnotations();
                this.originalAxioms_.put((Object)key, (Object)axiom);
                this.axiomOccurrences_.put((Object)key, (Object)ontology);
            }
        }
        this.axiomsUpToDate_ = true;
        return true;
    }

    synchronized boolean invalidate() {
        int i;
        if (!this.axiomsUpToDate_) {
            return false;
        }
        this.axiomsUpToDate_ = false;
        this.importsClosure_ = null;
        this.originalAxioms_.clear();
        this.axiomOccurrences_.clear();
        try {
            for (i = 0; i < this.listeners_.size(); ++i) {
                this.listeners_.get(i).statedAxiomsChanged();
            }
        }
        catch (Throwable e) {
            LOGGER_.warn("Remove the listener due to an exception", e);
            this.removeListener(this.listeners_.get(i));
        }
        return true;
    }

    void invalidateLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportsClosureRecord.this.invalidate();
            }
        });
    }

    public static interface ChangeListener {
        public void statedAxiomsChanged();
    }
}

