/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.liveontologies.protege.explanation.proof.ImportsClosureManager;
import org.liveontologies.protege.explanation.proof.ProofManager;
import org.liveontologies.protege.explanation.proof.ProofServiceManager;
import org.liveontologies.protege.explanation.proof.list.ProofFrame;
import org.liveontologies.protege.explanation.proof.list.ProofFrameList;
import org.liveontologies.protege.explanation.proof.service.ProofService;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.explanation.ExplanationResult;
import org.semanticweb.owlapi.model.OWLAxiom;

public class ProofBasedExplanationResult
extends ExplanationResult
implements ProofManager.ChangeListener {
    private static final long serialVersionUID = -4072183414834233365L;
    private final ProofManager proofManager_;
    private final OWLEditorKit kit_;
    private final ProofFrame frame_;
    private final ProofFrameList frameList_;
    private final JScrollPane scrollPane;

    private ProofBasedExplanationResult(ProofManager proofManager) {
        this.setLayout(new BorderLayout());
        this.proofManager_ = proofManager;
        this.kit_ = proofManager.getOWLEditorKit();
        Collection<ProofService> proofServices = this.proofManager_.getServices();
        switch (proofServices.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.proofManager_.selectService(proofServices.iterator().next());
                break;
            }
            default: {
                JComboBox<ProofService> proofServiceSelector = this.createComboBox(proofServices);
                this.add(proofServiceSelector, "North");
            }
        }
        this.proofManager_.addListener(this);
        this.frame_ = new ProofFrame(this.proofManager_, this.kit_);
        this.frameList_ = new ProofFrameList(this.kit_, this.frame_);
        this.scrollPane = new JScrollPane((Component)((Object)this.frameList_));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add(this.scrollPane, "Center");
    }

    public ProofBasedExplanationResult(ProofServiceManager proofServiceMan, ImportsClosureManager importsClosureMan, OWLAxiom entailment) {
        this(new ProofManager(proofServiceMan, importsClosureMan.getImportsClosure(proofServiceMan.getOWLEditorKit().getModelManager().getActiveOntology()), entailment));
    }

    public void dispose() {
        this.frame_.dispose();
        this.frameList_.dispose();
        this.proofManager_.removeListener(this);
        this.proofManager_.dispose();
    }

    private JComboBox<ProofService> createComboBox(Collection<ProofService> proofServices) {
        ProofService[] services = proofServices.toArray(new ProofService[proofServices.size()]);
        final JComboBox<ProofService> selector = new JComboBox<ProofService>(services);
        if (services.length > 0) {
            selector.setSelectedItem(services[0]);
            this.proofManager_.selectService(services[0]);
        }
        selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProofBasedExplanationResult.this.proofManager_.selectService((ProofService)selector.getSelectedItem());
            }
        });
        return selector;
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public void updateProofRoot() {
        this.frame_.updateProof();
        this.scrollPane.validate();
    }

    public Dimension getPreferredSize() {
        Dimension workspaceSize = this.kit_.getWorkspace().getSize();
        int width = (int)(workspaceSize.getWidth() * 0.8);
        int height = (int)(workspaceSize.getHeight() * 0.7);
        return new Dimension(width, height);
    }

    @Override
    public void proofRootChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProofBasedExplanationResult.this.updateProofRoot();
            }
        });
    }
}

