/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof;

import org.liveontologies.protege.explanation.proof.ImportsClosureManager;
import org.liveontologies.protege.explanation.proof.KeyEventManager;
import org.liveontologies.protege.explanation.proof.ProofBasedExplanationResult;
import org.liveontologies.protege.explanation.proof.ProofServiceManager;
import org.liveontologies.protege.explanation.proof.service.ProofService;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.explanation.ExplanationResult;
import org.protege.editor.owl.ui.explanation.ExplanationService;
import org.semanticweb.owlapi.model.OWLAxiom;

public class ProofBasedExplanationService
extends ExplanationService {
    private ProofServiceManager proofServiceMan_;
    private ImportsClosureManager importsClosureMan_;

    public void initialise() throws Exception {
        OWLEditorKit kit = this.getOWLEditorKit();
        this.proofServiceMan_ = ProofServiceManager.get(kit);
        this.importsClosureMan_ = ImportsClosureManager.get(kit);
        KeyEventManager.initialise(kit);
    }

    public void dispose() {
    }

    public boolean hasExplanation(OWLAxiom axiom) {
        for (ProofService service : this.proofServiceMan_.getProofServices()) {
            if (!service.hasProof(axiom)) continue;
            return true;
        }
        return false;
    }

    public ExplanationResult explain(OWLAxiom entailment) {
        return new ProofBasedExplanationResult(this.proofServiceMan_, this.importsClosureMan_, entailment);
    }
}

