/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.liveontologies.protege.explanation.proof.ImportsClosureRecord;
import org.liveontologies.protege.explanation.proof.ProofServiceManager;
import org.liveontologies.protege.explanation.proof.preferences.ProofBasedExplPrefs;
import org.liveontologies.protege.explanation.proof.service.ProofService;
import org.liveontologies.puli.DynamicProof;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.LeafProofNode;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.ProofNode;
import org.liveontologies.puli.ProofNodes;
import org.liveontologies.puli.Proofs;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofManager
implements ImportsClosureRecord.ChangeListener,
DynamicProof.ChangeListener,
Disposable {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ProofManager.class);
    private final ProofServiceManager proofServiceMan_;
    private final OWLAxiom entailment_;
    private final ImportsClosureRecord importsClosureRec_;
    private DynamicProof<Inference<? extends OWLAxiom>> proof_ = null;
    private ProofService proofService_ = null;
    private ProofNode<OWLAxiom> proofRoot_ = null;
    private boolean proofRootUpToDate_ = false;
    private final List<ChangeListener> listeners_ = new ArrayList<ChangeListener>();

    ProofManager(ProofServiceManager proofServiceMan, ImportsClosureRecord importsClosureRec, OWLAxiom entailment) {
        this.proofServiceMan_ = proofServiceMan;
        this.importsClosureRec_ = importsClosureRec;
        this.entailment_ = entailment;
        this.importsClosureRec_.addListener(this);
    }

    public OWLAxiom getEntailment() {
        return this.entailment_;
    }

    public OWLOntology getOntology() {
        return this.importsClosureRec_.getRootOntology();
    }

    public ProofServiceManager getProofServiceManager() {
        return this.proofServiceMan_;
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.proofServiceMan_.getOWLEditorKit();
    }

    public ProofService getProofService() {
        return this.proofService_;
    }

    public synchronized void selectService(ProofService proofService) {
        this.proofService_ = proofService;
        if (this.proof_ != null) {
            this.proof_.removeListener((DynamicProof.ChangeListener)this);
            this.proof_.dispose();
        }
        this.proof_ = proofService.getProof(this.entailment_);
        this.proof_.addListener((DynamicProof.ChangeListener)this);
        this.invalidateProofRoot();
    }

    public synchronized ProofNode<OWLAxiom> getProofRoot() {
        if (!this.proofRootUpToDate_) {
            if (this.proof_ == null) {
                this.proofRoot_ = new LeafProofNode((Object)this.entailment_);
            } else {
                Set<OWLAxiom> stated = this.importsClosureRec_.getStatedAxiomsWithoutAnnotations();
                boolean removeUnnecessaryInferences = ProofBasedExplPrefs.create().load().removeUnnecessaryInferences;
                Proof processedProof = Proofs.removeAssertedInferences(this.proof_, stated);
                if (removeUnnecessaryInferences) {
                    processedProof = Proofs.prune((Proof)processedProof, (Object)this.entailment_);
                }
                this.proofRoot_ = ProofNodes.create((Proof)processedProof, (Object)this.entailment_);
                this.proofRoot_ = ProofNodes.eliminateNotDerivableAndCycles(this.proofRoot_);
                if (this.proofService_ != null && this.proofRoot_ != null) {
                    this.proofRoot_ = this.proofService_.postProcess(this.proofRoot_);
                }
                if (this.proofRoot_ != null) {
                    this.proofRoot_ = ProofNodes.removeAssertedInferences(this.proofRoot_);
                }
            }
            this.proofRootUpToDate_ = true;
        }
        return this.proofRoot_;
    }

    public synchronized void addListener(ChangeListener listener) {
        this.listeners_.add(listener);
    }

    public synchronized void removeListener(ChangeListener listener) {
        this.listeners_.remove(listener);
    }

    public List<? extends OWLOntology> getHomeOntologies(OWLAxiom axiom) {
        return this.importsClosureRec_.getHomeOntologies(axiom);
    }

    public List<? extends OWLAxiom> getMatchingAxioms(OWLAxiom axiom) {
        return this.importsClosureRec_.getMatchingAxioms(axiom);
    }

    public Collection<ProofService> getServices() {
        ArrayList<ProofService> result = new ArrayList<ProofService>();
        for (ProofService service : this.proofServiceMan_.getProofServices()) {
            if (!service.hasProof(this.entailment_)) continue;
            result.add(service);
        }
        return result;
    }

    public void dispose() {
        this.importsClosureRec_.removeListener(this);
        if (this.proof_ != null) {
            this.proof_.removeListener((DynamicProof.ChangeListener)this);
            this.proof_.dispose();
        }
    }

    @Override
    public void statedAxiomsChanged() {
        this.invalidateProofRootLater();
    }

    public void inferencesChanged() {
        this.invalidateProofRootLater();
    }

    private void invalidateProofRootLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProofManager.this.invalidateProofRoot();
            }
        });
    }

    private synchronized boolean invalidateProofRoot() {
        int i;
        if (!this.proofRootUpToDate_) {
            return false;
        }
        this.proofRootUpToDate_ = false;
        this.proofRoot_ = null;
        try {
            for (i = 0; i < this.listeners_.size(); ++i) {
                this.listeners_.get(i).proofRootChanged();
            }
        }
        catch (Throwable e) {
            LOGGER_.warn("Remove the listener due to an exception", e);
            this.removeListener(this.listeners_.get(i));
        }
        return true;
    }

    public static interface ChangeListener {
        public void proofRootChanged();
    }
}

