/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof;

import java.util.ArrayList;
import java.util.Collection;
import org.liveontologies.protege.explanation.proof.service.ProofPlugin;
import org.liveontologies.protege.explanation.proof.service.ProofPluginLoader;
import org.liveontologies.protege.explanation.proof.service.ProofService;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.OWLEditorKit;

public class ProofServiceManager
implements Disposable {
    private static final String KEY_ = "org.liveontologies.protege.explanation.proof.services";
    private final OWLEditorKit kit_;
    private final Collection<ProofService> services_;

    private ProofServiceManager(OWLEditorKit kit) throws Exception {
        this.kit_ = kit;
        this.services_ = new ArrayList<ProofService>();
        ProofPluginLoader loader = new ProofPluginLoader(this.kit_);
        for (ProofPlugin plugin : loader.getPlugins()) {
            ProofService service = plugin.newInstance();
            service.initialise();
            this.services_.add(service);
        }
    }

    public static synchronized ProofServiceManager get(OWLEditorKit editorKit) throws Exception {
        ProofServiceManager m = (ProofServiceManager)editorKit.getModelManager().get((Object)KEY_);
        if (m == null) {
            m = new ProofServiceManager(editorKit);
            editorKit.put((Object)KEY_, (Disposable)m);
        }
        return m;
    }

    public void dispose() {
        for (ProofService proofService : this.services_) {
            proofService.dispose();
        }
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.kit_;
    }

    public Collection<ProofService> getProofServices() {
        return this.services_;
    }
}

