/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof.editing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.liveontologies.protege.explanation.proof.editing.OWLAxiomChecker;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;

public class OWLAxiomEditor
extends AbstractOWLObjectEditor<OWLAxiom>
implements VerifiedInputEditor {
    private final OWLAxiomChecker axiomChecker_;
    private final ExpressionEditor<OWLAxiom> editor_;
    private final JComponent editingComponent_;

    public OWLAxiomEditor(OWLEditorKit editorKit, OWLAxiomChecker axiomChecker) {
        this.axiomChecker_ = axiomChecker;
        this.editor_ = new ExpressionEditor(editorKit, (OWLExpressionChecker)axiomChecker);
        this.editingComponent_ = new JPanel(new BorderLayout());
        this.editingComponent_.add((Component)this.editor_);
        this.editingComponent_.setPreferredSize(new Dimension(400, 200));
    }

    public boolean setEditedObject(OWLAxiom axiom) {
        if (axiom == null) {
            return true;
        }
        this.editor_.setText(this.getRendering(axiom));
        return true;
    }

    public String getEditorTypeName() {
        return "OWL Axiom Editor";
    }

    public boolean canEdit(Object object) {
        return object instanceof OWLAxiom && this.isParsable((OWLAxiom)object);
    }

    String getRendering(OWLAxiom axiom) {
        return this.axiomChecker_.getRendering(axiom);
    }

    boolean isParsable(OWLAxiom axiom) {
        try {
            this.axiomChecker_.check(this.getRendering(axiom));
            return true;
        }
        catch (OWLExpressionParserException e) {
            return false;
        }
    }

    public JComponent getEditorComponent() {
        return this.editingComponent_;
    }

    public OWLAxiom getEditedObject() {
        try {
            if (this.editor_.isWellFormed()) {
                return (OWLAxiom)this.editor_.createObject();
            }
            return null;
        }
        catch (OWLException e) {
            return null;
        }
    }

    public void dispose() {
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor_.addStatusChangedListener(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor_.removeStatusChangedListener(listener);
    }
}

