/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.liveontologies.protege.explanation.proof.OWLRenderer;
import org.liveontologies.protege.explanation.proof.ProofManager;
import org.liveontologies.protege.explanation.proof.editing.OWLAxiomChecker;
import org.liveontologies.protege.explanation.proof.list.AbstractProofFrameListRow;
import org.liveontologies.protege.explanation.proof.list.InferenceRow;
import org.liveontologies.protege.explanation.proof.list.InferenceSection;
import org.liveontologies.protege.explanation.proof.list.ProofFrameListRow;
import org.liveontologies.protege.explanation.proof.list.ProofRoot;
import org.liveontologies.puli.ProofNode;
import org.liveontologies.puli.ProofStep;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;

class ConclusionSection
extends AbstractProofFrameListRow<InferenceRow>
implements ProofFrameListRow,
OWLFrameSectionRow<ProofRoot, OWLAxiom, OWLAxiom>,
Disposable,
OWLObjectEditorHandler<OWLAxiom> {
    private final InferenceSection parentSection_;
    private final ProofNode<OWLAxiom> conclusion_;
    private final boolean editable_;
    private final boolean inferred_;
    private boolean expanded_ = false;
    private int visibleChildLimit_;
    private final List<? extends OWLAxiom> originalAxioms_;
    private final List<? extends OWLOntology> ontologies_;

    ConclusionSection(InferenceSection parentSection, ProofNode<OWLAxiom> conclusion) {
        this.parentSection_ = parentSection;
        this.conclusion_ = conclusion;
        ProofManager wbManager = parentSection.getFrame().getWorkbenchManager();
        OWLAxiom key = ((OWLAxiom)conclusion.getMember()).getAxiomWithoutAnnotations();
        this.originalAxioms_ = wbManager.getMatchingAxioms(key);
        this.ontologies_ = parentSection.getFrame().getWorkbenchManager().getHomeOntologies(key);
        this.editable_ = this.isAsserted() && this.getAxiomChecker().isParsable(this.getAxiom());
        boolean bl = this.inferred_ = !conclusion.getInferences().isEmpty();
        if (!this.inferred_) {
            this.expanded_ = true;
        }
        this.visibleChildLimit_ = parentSection.getFrame().getDisplayedInferencesPerConclusionLimit();
    }

    public ProofNode<OWLAxiom> getConclusion() {
        return this.conclusion_;
    }

    @Override
    public InferenceRow getParent() {
        return this.parentSection_.getRow();
    }

    @Override
    public boolean isExpanded() {
        return this.expanded_;
    }

    @Override
    public boolean isExpandable() {
        return this.isInferred();
    }

    @Override
    public void toggleExpandState() {
        if (!this.isExpandable()) {
            return;
        }
        this.expanded_ ^= true;
    }

    boolean isAsserted() {
        return !this.ontologies_.isEmpty();
    }

    OWLRenderer getRenderer() {
        return this.parentSection_.getFrame().getRenderer();
    }

    OWLAxiomChecker getAxiomChecker() {
        return this.parentSection_.getFrame().getAxiomChecker();
    }

    boolean hasMoreChildren() {
        return super.getChildren().size() > this.visibleChildLimit_;
    }

    void loadMoreChildren() {
        this.visibleChildLimit_ += this.parentSection_.getFrame().getDisplayedInferencesPerConclusionLimit();
    }

    @Override
    public synchronized List<InferenceRow> getChildren() {
        List<InferenceRow> allChildren = super.getChildren();
        if (this.visibleChildLimit_ >= allChildren.size()) {
            return allChildren;
        }
        return super.getChildren().subList(0, this.visibleChildLimit_);
    }

    public List<? extends OWLObject> getManipulatableObjects() {
        return Arrays.asList(this.getAxiom());
    }

    public OWLFrameSection<ProofRoot, OWLAxiom, OWLAxiom> getFrameSection() {
        return this.parentSection_;
    }

    public boolean isEditable() {
        return this.editable_;
    }

    public boolean isDeleteable() {
        return this.isAsserted();
    }

    public boolean isInferred() {
        return this.inferred_;
    }

    public OWLObjectEditor<OWLAxiom> getEditor() {
        OWLObjectEditor<OWLAxiom> editor = this.parentSection_.getEditor();
        editor.setEditedObject((Object)this.getAxiom());
        editor.setHandler((OWLObjectEditorHandler)this);
        return editor;
    }

    public boolean checkEditorResults(OWLObjectEditor<OWLAxiom> editor) {
        return true;
    }

    public boolean canAcceptDrop(List<OWLObject> objects) {
        return false;
    }

    public boolean dropObjects(List<OWLObject> objects) {
        return false;
    }

    @Override
    public String getTooltip() {
        StringBuilder sb = new StringBuilder();
        boolean delim = false;
        if (this.isInferred()) {
            sb.append("Inferred");
            delim = true;
        }
        if (this.isAsserted()) {
            if (delim) {
                sb.append(" and ");
            }
            sb.append("Asserted in: ");
            sb.append(this.getRenderer().render((OWLObject)this.getOntology()));
        }
        return sb.toString();
    }

    public void handleEdit() {
    }

    public boolean handleDelete() {
        return false;
    }

    public ProofRoot getRoot() {
        return this.parentSection_.getRootObject();
    }

    public OWLAxiom getAxiom() {
        if (this.originalAxioms_.isEmpty()) {
            return (OWLAxiom)this.conclusion_.getMember();
        }
        return this.originalAxioms_.get(0);
    }

    public Object getUserObject() {
        return null;
    }

    public void setUserObject(Object object) {
    }

    public OWLOntology getOntology() {
        if (this.ontologies_.isEmpty()) {
            return null;
        }
        return this.ontologies_.get(0);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.getOWLModelManager().getOWLOntologyManager();
    }

    public List<? extends OWLOntologyChange> getDeletionChanges() {
        return Collections.singletonList(new RemoveAxiom(this.getOntology(), this.getAxiom()));
    }

    OWLModelManager getOWLModelManager() {
        return this.parentSection_.getFrame().getEditorKit().getOWLModelManager();
    }

    public String getRendering() {
        OWLAxiom ax = this.getAxiom();
        return this.getRenderer().render((OWLObject)ax);
    }

    public String toString() {
        return this.getRendering();
    }

    public void handleEditingFinished(Set<OWLAxiom> editedObjects) {
        OWLAxiom oldAxiom = this.getAxiom();
        Set axiomAnnotations = oldAxiom.getAnnotations();
        ArrayList<Object> changes = new ArrayList<Object>();
        OWLOntology ontology = this.getOntology();
        changes.add(new RemoveAxiom(ontology, oldAxiom));
        for (OWLAxiom newAxiom : editedObjects) {
            if (!axiomAnnotations.isEmpty()) {
                newAxiom = newAxiom.getAnnotatedAxiom(axiomAnnotations);
            }
            changes.add(new AddAxiom(ontology, newAxiom));
        }
        this.getOWLModelManager().applyChanges(changes);
    }

    @Override
    List<InferenceRow> computeChildSections() {
        Collection inferences = this.conclusion_.getInferences();
        ArrayList<InferenceRow> result = new ArrayList<InferenceRow>(inferences.size());
        for (ProofStep inf : inferences) {
            result.add(new InferenceSection(this.parentSection_.getFrame(), this, (ProofStep<OWLAxiom>)inf).getRow());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    void copySettingsFrom(AbstractProofFrameListRow<?> previous) {
        this.visibleChildLimit_ = ((ConclusionSection)previous).visibleChildLimit_;
        super.copySettingsFrom(previous);
    }

    @Override
    public boolean matches(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ConclusionSection) {
            ConclusionSection other = (ConclusionSection)o;
            boolean result = ((OWLAxiom)this.conclusion_.getMember()).equals(other.conclusion_.getMember());
            return result;
        }
        return false;
    }

    @Override
    public <O> O accept(ProofFrameListRow.Visitor<O> visitor) {
        return visitor.visit(this);
    }
}

