/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.liveontologies.protege.explanation.proof.list.AbstractProofFrameListRow;
import org.liveontologies.protege.explanation.proof.list.ConclusionSection;
import org.liveontologies.protege.explanation.proof.list.InferenceSection;
import org.liveontologies.protege.explanation.proof.list.ProofFrameListRow;
import org.liveontologies.protege.explanation.proof.service.ProofService;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.ProofNode;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

class InferenceRow
extends AbstractProofFrameListRow<ConclusionSection>
implements Comparable<InferenceRow> {
    private final InferenceSection section_;
    private int hash_ = 0;

    InferenceRow(InferenceSection section) {
        this.section_ = section;
    }

    InferenceSection getInferenceSection() {
        return this.section_;
    }

    String getName() {
        return this.section_.getName();
    }

    @Override
    public ConclusionSection getParent() {
        return this.section_.getParentSection();
    }

    @Override
    List<ConclusionSection> computeChildSections() {
        List premises = this.section_.getInference().getPremises();
        ArrayList<ConclusionSection> result = new ArrayList<ConclusionSection>(premises.size());
        for (ProofNode premise : premises) {
            result.add(new ConclusionSection(this.section_, (ProofNode<OWLAxiom>)premise));
        }
        return result;
    }

    @Override
    public boolean isExpanded() {
        return true;
    }

    @Override
    public boolean isExpandable() {
        return false;
    }

    @Override
    public String getTooltip() {
        ProofService proofService = this.section_.getFrame().getWorkbenchManager().getProofService();
        if (proofService == null) {
            return null;
        }
        Inference<? extends OWLAxiom> example = proofService.getExample((Inference<? extends OWLAxiom>)this.section_.getInference().getInference());
        if (example == null) {
            return null;
        }
        OWLModelManager man = this.section_.getFrame().getEditorKit().getOWLModelManager();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<style>");
        sb.append("ol li { margin: 4px 0; font-weight: bold; }");
        sb.append("p { font-weight: bold; }");
        sb.append("</style>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<p>");
        sb.append(man.getRendering((OWLObject)example.getConclusion()));
        sb.append("</p>");
        sb.append("<br>");
        sb.append("&emsp;");
        List premises = example.getPremises();
        if (premises.isEmpty()) {
            sb.append("is a tautology");
        } else {
            sb.append("is inferred from:");
        }
        sb.append("<ol>");
        for (int i = 0; i < premises.size(); ++i) {
            sb.append("<li>");
            sb.append(man.getRendering((OWLObject)premises.get(i)));
        }
        sb.append("</ol>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public void toggleExpandState() {
    }

    public int hashCode() {
        if (this.hash_ == 0) {
            this.hash_ = InferenceRow.class.hashCode() + this.section_.getName().hashCode();
            for (ProofNode premise : this.section_.getInference().getPremises()) {
                this.hash_ += ((OWLAxiom)premise.getMember()).hashCode();
            }
        }
        return this.hash_;
    }

    public String toString() {
        return this.section_.toString();
    }

    @Override
    public int compareTo(InferenceRow other) {
        int otherHash;
        int hash = this.hashCode();
        if (hash == (otherHash = other.hashCode())) {
            if (this.equals(other)) {
                return 0;
            }
            return this.toString().compareTo(other.toString());
        }
        return hash < otherHash ? -1 : 1;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.section_.dispose();
    }

    @Override
    public boolean matches(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (o instanceof InferenceRow) {
            InferenceRow other = (InferenceRow)o;
            if (!this.section_.getName().equals(other.section_.getName())) {
                return false;
            }
            List premises = this.section_.getInference().getPremises();
            List otherPremises = other.section_.getInference().getPremises();
            if (premises.size() != otherPremises.size()) {
                return false;
            }
            Iterator premiseIterator = premises.iterator();
            Iterator otherPremisesIterator = otherPremises.iterator();
            while (premiseIterator.hasNext()) {
                if (((OWLAxiom)((ProofNode)premiseIterator.next()).getMember()).equals(((ProofNode)otherPremisesIterator.next()).getMember())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public <O> O accept(ProofFrameListRow.Visitor<O> visitor) {
        return visitor.visit(this);
    }
}

