/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.proof.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.liveontologies.protege.explanation.proof.list.ConclusionSection;
import org.liveontologies.protege.explanation.proof.list.InferenceRow;
import org.liveontologies.protege.explanation.proof.list.ProofFrame;
import org.liveontologies.protege.explanation.proof.list.ProofRoot;
import org.liveontologies.puli.ProofNode;
import org.liveontologies.puli.ProofStep;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

class InferenceSection
implements OWLFrameSection<ProofRoot, OWLAxiom, OWLAxiom> {
    private final ProofFrame frame_;
    private final ConclusionSection parentSection_;
    private final ProofStep<OWLAxiom> inference_;
    private final InferenceRow inferenceRow_;

    InferenceSection(ProofFrame frame, ConclusionSection parentSection, ProofStep<OWLAxiom> inference) {
        this.frame_ = frame;
        this.parentSection_ = parentSection;
        this.inference_ = inference;
        this.inferenceRow_ = new InferenceRow(this);
    }

    InferenceSection(ProofFrame frame, ProofStep<OWLAxiom> inference) {
        this(frame, null, inference);
    }

    ConclusionSection getParentSection() {
        return this.parentSection_;
    }

    ProofStep<OWLAxiom> getInference() {
        return this.inference_;
    }

    public String getName() {
        return this.getLabel();
    }

    InferenceRow getRow() {
        return this.inferenceRow_;
    }

    public boolean checkEditorResults(OWLObjectEditor<OWLAxiom> editor) {
        return true;
    }

    public boolean dropObjects(List<OWLObject> objects) {
        return false;
    }

    public void dispose() {
    }

    public ProofFrame getFrame() {
        return this.frame_;
    }

    public void setRootObject(ProofRoot rootObject) {
    }

    public String getLabel() {
        return this.inference_.getName();
    }

    public String getRowLabel(OWLFrameSectionRow<ProofRoot, OWLAxiom, OWLAxiom> row) {
        return null;
    }

    public ProofRoot getRootObject() {
        return this.frame_.getRootObject();
    }

    public List<OWLFrameSectionRow<ProofRoot, OWLAxiom, OWLAxiom>> getRows() {
        return Collections.unmodifiableList(this.inferenceRow_.getChildren());
    }

    public List<OWLAxiom> getAxioms() {
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        for (ProofNode premise : this.inference_.getPremises()) {
            axioms.add((OWLAxiom)premise.getMember());
        }
        return axioms;
    }

    public int getRowIndex(OWLFrameSectionRow row) {
        return this.inferenceRow_.getChildren().indexOf(row);
    }

    public OWLObjectEditor<OWLAxiom> getEditor() {
        return this.frame_.getAxiomEditor();
    }

    public Comparator<OWLFrameSectionRow<ProofRoot, OWLAxiom, OWLAxiom>> getRowComparator() {
        return null;
    }

    public boolean canAdd() {
        return false;
    }

    public boolean canAcceptDrop(List<OWLObject> objects) {
        return false;
    }

    public String toString() {
        return this.inference_.toString();
    }
}

